@extends('Template::layouts.master')
@section('content')
    <div class="row justify-content-center">
        <div class="col-md-12">

            <div class="card custom--card">
                <div class="card-body">
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show active" id="pills-all" role="tabpanel" aria-labelledby="pills-all-tab" tabindex="0">
                            <div class="table-responsive ">
                                <table class="table table--responsive--xl">
                                    <thead>
                                        <tr>
                                            <th>@lang('TRX')</th>
                                            <th>@lang('Transacted')</th>
                                            <th>@lang('Amount')</th>
                                            <th>@lang('Post Balance')</th>
                                            <th>@lang('Details')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($transactions as $transaction)
                                            <tr>
                                                <td>
                                                    <div>
                                                        <span class="fw-bold">
                                                            {{ $transaction->trx }}
                                                        </span>
                                                    </div>
                                                </td>

                                                <td>
                                                    <span>{{ showDateTime($transaction->created_at) }}<br>{{ diffForHumans($transaction->created_at) }}</span>
                                                </td>
                                                <td>
                                                    <div>
                                                        {{ showAmount($transaction->amount) }} + <span class="text--danger" data-bs-toggle="tooltip" title="@lang('Processing Charge')">{{ showAmount($transaction->charge) }} </span>
                                                        <br>
                                                        <strong data-bs-toggle="tooltip" title="@lang('Amount with charge')">
                                                            {{ showAmount($transaction->amount + $transaction->charge) }}
                                                        </strong>
                                                    </div>
                                                </td>
                                                <td>
                                                    {{ showAmount($transaction->post_balance) }}
                                                </td>
                                                <td>{{ __($transaction->details) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="100%">{{ __($emptyMessage) }}</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        @if ($transactions->hasPages())
                            <div class="card-footer">
                                {{ paginateLinks($transactions) }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <form>
        <div class="input-group">
            <input type="search" name="search" class="form--control form-control" value="{{ request()->search }}" placeholder="@lang('Search by transactions')">
            <button class="input-group-text border-0 bg--base text-white">
                <i class="las la-search"></i>
            </button>
        </div>
    </form>
@endpush

