@extends('Template::layouts.master')
@section('content')
    <div class="social-account-container">
        <div class="account-list">
            @foreach ($platforms as $platform)
                <div class="account-item">
                    <span class="account-item__icon">
                        <img src="{{ asset('assets/images/platform/' . $platform->image ?? '') }}" alt="">
                    </span>
                    <div class="account-item__content">
                        @if ($platform->name == 'Telegram')
                            <a href="javascript:void(0)" class="btn btn-outline--dark btn--xsm pill" data-bs-toggle="modal" data-bs-target="#connectTelegramModal">+ @lang('Connect Profile') </a>
                        @else
                            <a href="{{ route('user.social.connect', strtolower($platform->name)) }}" class="btn btn-outline--dark btn--xsm pill"> + @lang('Connect Profile') </a>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>

        <div class="connected_account mt-4">
            @if ($accounts->count() > 0)
                <h5>@lang('Connected Accounts')</h5>
            @endif
            <div class="account-list">
                @foreach ($accounts as $account)
                    <div class="account-item">
                        <div class="account-item__inner">
                            <div class="form--radio form-check post-list__item">
                                <span class="single-post">
                                    <span class="single-post__thumb">
                                        <img src="{{ $account->profile_image }}" alt="">
                                    </span>
                                    <span class="single-post__icon {{ strtolower(__($account->platform?->name)) }}">
                                        <img src="{{ getImage('assets/images/platform/' . $account->platform?->image ?? '') }}" alt="">
                                    </span>
                                </span>
                            </div>
                            <div class="account-item__content">
                                <a href="{{ route('user.analytics.index', ['account_id' => $account->id]) }}" class="btn btn-outline--dark btn--xsm pill">
                                    {{ __($account->profile_name) }}
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    @include('Template::partials.telegram_connect_modal')

    <x-confirmation-modal />
@endsection


@push('style')
    <style>
        .btn--xsm {
            padding: 8px 12px;
        }
    </style>
@endpush
