@extends('Template::layouts.master')

@section('content')
    @php
        $memberContent = getContent('members_plan.content', true);
    @endphp

    <div class="row mb-60">
        <div class="col-md-12">
            @if (!$user->plan_id && $user->expired_at < now())
                <h3>{{ __($memberContent->data_values->no_plan_purchase_heading) }}</h3>
                <p>{{ __($memberContent->data_values->no_plan_purchase_content) }}</p>
            @elseif($user->expired_at < now())
                <h3>{{ __($memberContent->data_values->expired_plan_heading) }}</h3>
                <p>{{ __($memberContent->data_values->expired_plan_content) }}</p>
            @else
                <h3>
                    @lang('Your plan will expire on ') {{ $user->expired_at->format('F j, Y') ?? '' }}
                </h3>
                <strong>@lang('Your are using') {{ $user?->plan?->name ?? 'Free ' }} @lang('Plan')</strong>
            @endif
        </div>
    </div>


    @include('Template::sections.pricing_plan', ['dashboard' => true])

    @include('Template::partials.plan_purchase_modal')
@endsection
