@extends('Template::layouts.auth')
@section('content')
    @php
        $dataKey = 'register';
        $authContent = getContent('register.content', true);
        $policyPages = getContent('policy_pages.element', false, orderById: true);
    @endphp

    @if (gs('registration'))
        <form action="{{ route('user.register') }}" method="POST" class="verify-gcaptcha disableSubmission">
            @csrf
            <div class="row">
                @if (session()->get('reference') != null)
                  <div class="col-sm-12 wow fadeInUp" data-wow-duration="1s">
                        <div class="form-group">
                            <label for="referenceBy" class="form--label">@lang('Reference by')</label>
                            <input type="text" name="referBy" id="referenceBy" class="form--control" value="{{ session()->get('reference') }}" readonly>
                        </div>
                    </div>
                @endif
                <div class="col-sm-6 wow fadeInUp" data-wow-duration="1s">
                    <div class="form-group">
                        <label for="firstname" class="form--label"> @lang('First Name') </label>
                        <input type="text" class="form--control" id="firstname" value="{{ old('firstname') }}" name="firstname" required>
                    </div>
                </div>
                <div class="col-sm-6 wow fadeInUp" data-wow-duration="1s">
                    <div class="form-group">
                        <label for="lastname" class="form--label"> @lang('Last Name') </label>
                        <input type="text" class="form--control" id="lastname" value="{{ old('lastname') }}" name="lastname" required>
                    </div>
                </div>
                <div class="col-sm-12 wow fadeInUp" data-wow-duration="1s">
                    <div class="form-group">
                        <label for="email" class="form--label"> @lang('E-Mail Address') </label>
                        <input type="email" class="form--control checkUser" value="{{ request('email') ?? old('email') }}" name="email" id="email" required>
                    </div>
                </div>
                <div class="col-sm-6 wow fadeInUp" data-wow-duration="1s">
                    <div class="form-group">
                        <label for="password" class="form--label">@lang('Password')</label>
                        <div class="position-relative">
                            <input id="password" type="password" class="form-control form--control @if (gs('secure_password')) secure-password @endif" name="password" autocomplete="off">
                            <span class="password-show-hide fas fa-eye toggle-password fa-eye-slash" id="#password"></span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 wow fadeInUp" data-wow-duration="1s">
                    <div class="form-group">
                        <label for="confirm-password" class="form--label">@lang('Confirm Password')</label>
                        <div class="position-relative">
                            <input id="confirm-password" type="password" name="password_confirmation" class="form-control form--control" autocomplete="off">
                            <div class="password-show-hide fas fa-eye toggle-password fa-eye-slash" id="#confirm-password">
                            </div>
                        </div>
                    </div>
                </div>

                <x-captcha />

                <div class="col-sm-12 wow fadeInUp" data-wow-duration="1s">
                    <div class="form-group">
                        <div class="form--check">
                            <input class="form-check-input" type="checkbox" id="agree" @checked(old('agree')) name="agree" required>
                            <div class="form-check-label">
                                <label class="" for="agree"> @lang('I agree with') </label>
                                @foreach ($policyPages as $policy)
                                    <a href="{{ route('policy.pages', $policy->slug) }}" target="_blank" class="text--base">{{ __($policy->data_values->title) }}</a>
                                    @if (!$loop->last)
                                        ,
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 wow fadeInUp" data-wow-duration="1s">
                    <button type="submit" class="btn btn--base w-100 btn--lg" id="recaptcha"> @lang('Submit') </button>
                </div>

                @include('Template::partials.social_login', ['register' => true])

                <div class="col-sm-12 wow fadeInUp mt-3" data-wow-duration="1s">
                    <div class="have-account text-center">
                        <p class="have-account__text">@lang('Already have an account?') <a href="{{ route('user.login') }}" class="have-account__link"> @lang('Login') </a></p>
                    </div>
                </div>
            </div>
        </form>
    @else
        @include('Template::partials.registration_disabled')
    @endif
@endsection

<div class="modal fade " id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="existModalLongTitle">@lang('You are with us')</h5>
                <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <h6 class="text-center mb-0">@lang('You already have an account please Login ')</h6>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-dark btn-sm" data-bs-dismiss="modal">@lang('Close')</button>
                <a href="{{ route('user.login') }}" class="btn btn--base btn-sm">@lang('Login')</a>
            </div>
        </div>
    </div>
</div>

@if (gs('registration'))
    @if (gs('secure_password'))
        @push('script-lib')
            <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
        @endpush
    @endif

    @push('script')
        <script>
            "use strict";
            (function($) {

                $('.checkUser').on('focusout', function(e) {
                    var url = '{{ route('user.checkUser') }}';
                    var value = $(this).val();
                    var token = '{{ csrf_token() }}';

                    var data = {
                        email: value,
                        _token: token
                    }

                    $.post(url, data, function(response) {
                        if (response.data != false) {
                            $('#existModalCenter').modal('show');
                        }
                    });
                });
            })(jQuery);
        </script>
    @endpush
@endif
