@extends('Template::layouts.auth')

@section('content')
    @php
        $dataKey = 'login';
        $authContent = getContent('login.content', true);
    @endphp
    <form method="POST" action="{{ route('user.login') }}" class="verify-gcaptcha">
        @csrf
        <div class="row">
            <div class="col-sm-12 wow fadeInUp form-group" data-wow-duration="1s">
                <label for="username" class="form--label">@lang('Username or Email')</label>
                <input type="text" class="form--control form--control" id="username" name="username"
                       value="{{ old('username') }}" required>
            </div>
            <div class="col-sm-12 wow fadeInUp form-group" data-wow-duration="1s">
                <label for="password" class="form--label"> @lang('Password') </label>
                <div class="position-relative">
                    <input id="password" type="password" class="form-control form--control" name="password" required>
                    <span class="password-show-hide fas toggle-password fa-eye-slash" id="#password"></span>
                </div>
            </div>

            <div class="wow fadeInUp">
                <x-captcha />
            </div>

            <div class="col-sm-12 wow fadeInUp" data-wow-duration="1s">
                <div class="d-flex flex-wrap justify-content-between gap-3">
                    <div class="form--check">
                        <input class="form-check-input" type="checkbox" name="remember" id="remember"
                               {{ old('remember') ? 'checked' : '' }}>
                        <label class="form-check-label" for="remember">@lang('Remember Me')</label>
                    </div>
                    <a class="forgot-password text--base" href="{{ route('user.password.request') }}">@lang('Forgot your password?')</a>
                </div>
            </div>
            <div class="col-sm-12 mt-4 wow fadeInUp" data-wow-duration="1s">
                <button type="submit" id="recaptcha" class="btn btn--base w-100 btn--lg"> @lang('Submit')
                </button>
            </div>

            @include('Template::partials.social_login')

            @if (gs('registration'))
                <div class="col-sm-12 wow fadeInUp mt-3" data-wow-duration="1s">
                    <div class="have-account text-center">
                        <p class="have-account__text"> @lang('Don\'t have any account?')
                            <a href="{{ route('user.register') }}" class="have-account__link"> @lang('Register Now') </a>
                        </p>
                    </div>
                </div>
            @endif
        </div>
    </form>
@endsection
