@php
    $workProcessContent = getContent('work_process.content', true);
    $workProcessElements = getContent('work_process.element', orderById: true);
@endphp
<div class="how-work-section my-120">
    <div class="container">
        <div class="section-heading">
            <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                @include('Template::partials.star_svg')
                {{ __($workProcessContent->data_values?->heading) }}
            </span>
            <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                {{ __($workProcessContent->data_values?->subheading) }}
            </h2>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="how-works-wrapper">
                    @foreach ($workProcessElements ?? [] as $workProcessElement)
                        <div class="how-work__item">
                            <div class="how-work-item__pin">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                     fill="currentColor" class="bi bi-pin-angle-fill" viewBox="0 0 20 20">
                                    <path
                                          d="M9.828.722a.5.5 0 0 1 .354.146l4.95 4.95a.5.5 0 0 1 0 .707c-.48.48-1.072.588-1.503.588-.177 0-.335-.018-.46-.039l-3.134 3.134a6 6 0 0 1 .16 1.013c.046.702-.032 1.687-.72 2.375a.5.5 0 0 1-.707 0l-2.829-2.828-3.182 3.182c-.195.195-1.219.902-1.414.707s.512-1.22.707-1.414l3.182-3.182-2.828-2.829a.5.5 0 0 1 0-.707c.688-.688 1.673-.767 2.375-.72a6 6 0 0 1 1.013.16l3.134-3.133a3 3 0 0 1-.04-.461c0-.43.108-1.022.589-1.503a.5.5 0 0 1 .353-.146" />
                                </svg>
                            </div>
                            <div class="how-work-box">
                                <span class="how-work-item__number"> @lang('Step') {{ $loop->iteration }}</span>
                                <h4 class="how-work-item__title">
                                    {{ __($workProcessElement->data_values?->step ?? null) }}
                                </h4>
                                <p class="how-work-item__desc">
                                    {{ __($workProcessElement->data_values?->description ?? null) }}
                                </p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
