@php
    $toolsIntegrationContent = getContent('tools_integration.content', true);
    $toolsIntegrationElements = getContent('tools_integration.element', orderById: true);
@endphp
<div class="integration-section my-120">
    <div class="integration-section__shape">
        <img src="{{ frontendImage('tools_integration', $toolsIntegrationContent->data_values?->background_shape ?? null, '1905x610') }}" alt="@lang('image')">
    </div>
    <div class="container">
        <div class="section-heading">
            <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                @include('Template::partials.star_svg')
                {{ __($toolsIntegrationContent->data_values?->heading ?? null) }}
            </span>
            <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                {{ __($toolsIntegrationContent->data_values?->subheading ?? null) }}
            </h2>
        </div>
        <div class="row justify-content-center">
            <div class="col-xxl-9 col-xl-10">
                <div class="integration-wrapper">
                    @foreach ($toolsIntegrationElements ?? [] as $toolsIntegrationElement)
                        <div class="integration-item wow fadeInUp" data-wow-duration="1s">
                            <div class="integration-item__thumb">
                                <img src="{{ frontendImage('tools_integration', $toolsIntegrationElement->data_values?->image ?? null, '45x45') }}" alt="@lang('image')">
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
