@php
    $testimonialContent = getContent('testimonial.content', true);
    $testimonialElements = getContent('testimonial.element', orderById: true);
@endphp

<section class="testimonials my-120">
    <div class="container">
        <div class="section-heading">
            <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                @include('Template::partials.star_svg')
                {{ __($testimonialContent->data_values?->heading ?? null) }}
            </span>
            <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                {{ __($testimonialContent->data_values?->subheading ?? null) }}
            </h2>
        </div>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="testimonial-slide">
                    @foreach ($testimonialElements ?? [] as $testimonialElement)
                        <div class="single-testimonial-item">
                            <div class="single-testimonial-item__thumb">
                                <figure class="testimonial-img">
                                    <img src="{{ frontendImage('testimonial', $testimonialElement->data_values?->image ?? null, '200x200') }}"
                                         alt="@lang('Image')">
                                </figure>
                                <div class="single-testimonial-item__details">
                                    <h4 class="single-testimonial-item__name">
                                        {{ __($testimonialElement->data_values?->name ?? null) }} </h4>
                                    <span class="single-testimonial-item__designation">
                                        {{ __($testimonialElement->data_values?->designation ?? null) }} </span>
                                    <div class="testimonial-item__rating">
                                        <ul class="rating-list">
                                            @for ($rating = 0; $rating < ($testimonialElement->data_values?->rating_number ?? 0); $rating++)
                                                <li class="rating-list__item"><i class="fas fa-star"></i></li>
                                            @endfor
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <p class="single-testimonial-item__desc">
                                {{ __($testimonialElement->data_values?->description ?? null) }}
                            </p>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
