@php
    $publishContent = getContent('publish.content', true);
    $publishElements = getContent('publish.element', orderById: true);
@endphp
<div class="publish-section my-120">
    <div class="container">
        <div class="features-contents">
            <div class="row gy-4 justify-content-between">
                <div class="col-lg-6 pe-xl-4 align-self-center">
                    <div class="section-heading style-left">
                        <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                            @include('Template::partials.star_svg')
                            {{ __($publishContent->data_values?->heading ?? null) }}
                        </span>
                        <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                            {{ __($publishContent->data_values?->subheading ?? null) }}
                        </h2>
                    </div>
                    <div class="publish-content">
                        <p class="publish-content__desc wow fadeInUp" data-wow-duration="1s">
                            {{ __($publishContent->data_values?->content ?? null) }}
                        </p>
                        <ul class="content-list">
                            @foreach ($publishElements ?? [] as $publishElement)
                                <li class="content-list__item wow fadeInUp" data-wow-duration="1s">
                                    <span class="content-list__icon">
                                        @php
                                            echo $publishElement->data_values?->icon ?? null;
                                        @endphp
                                    </span>
                                    {{ __($publishElement->data_values?->title ?? null) }}
                                </li>
                            @endforeach
                        </ul>
                        <div class="publish-content__btn wow fadeInUp" data-wow-duration="1s">
                            <a href="{{ url($publishContent->data_values?->button_url ?? null) }}" class="btn btn--base">
                                @include('Template::partials.star_svg')
                                {{ __($publishContent->data_values?->button_name ?? null) }}
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 ps-lg-5">
                    <div class="publish-wrapper wow fadeInUp" data-wow-duration="1s">
                        <div class="publish-thumb">
                            <img src="{{ frontendImage('publish', $publishContent->data_values?->image ?? null, '600x590') }}"
                                 alt="@lang('Image')">
                        </div>
                        <div class="publish-wrapper__shape"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
