@php
    $featureContent = getContent('feature.content', true);
    $featureElements = getContent('feature.element', orderById: true);
@endphp

<section class="feature-section my-120">
    <div class="container">
        <div class="section-heading">
            <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                @include('Template::partials.star_svg')
                {{ __($featureContent?->data_values?->heading ?? null) }}
            </span>
            <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                {{ __($featureContent?->data_values?->subheading ?? null) }}
            </h2>
        </div>
        <div class="feature-wrapper">
            @foreach ($featureElements ?? [] as $featureElement)
                <div class="feature-card wow fadeInUp" data-wow-duration="1s">
                    <div class="feature-item">
                        <img class="feature-item__icon_shape" src="{{ frontendImage('feature', $featureElement?->data_values?->image ?? null, '40x40') }}">
                        <div class="feature-item__icon">
                            <img src="{{ frontendImage('feature', $featureElement?->data_values?->image ?? null, '40x40') }}">
                        </div>
                        <h5 class="feature-item__title">
                            {{ __($featureElement?->data_values?->title ?? null) }}
                        </h5>
                        <p class="feature-item__desc">
                            {{ __($featureElement?->data_values?->description ?? null) }}
                        </p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
