@php
    $faqContent = getContent('faq.content', true);
    $faqElements = getContent('faq.element', limit: 6, orderById: true);
@endphp
<div class="faq-section py-120">
    <div class="container">
        <div class="row gy-4 justify-content-between">
            <div class="col-xxl-5 col-lg-6">
                <div class="section-heading style-left">
                    <div>
                        <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                            @include('Template::partials.star_svg')
                            {{ __($faqContent->data_values?->heading ?? null) }}
                        </span>
                        <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                            {{ __($faqContent->data_values?->subheading ?? null) }}
                        </h2>
                        <p class="section-heading__desc wow fadeInUp" data-wow-duration="1s">
                            {{ __($faqContent->data_values?->short_details ?? null) }}
                        </p>
                    </div>
                    <div class="faq-info">
                        <div class="faq-info__item">
                            <div class="faq-info__heading">{{ __($faqContent->data_values?->title_one ?? null) }}</div>
                            <a href="{{ url($faqContent->data_values?->button_one_link ?? null) }}" class="faq-info__link">{{ __($faqContent->data_values?->button_one_name ?? null) }}</a>
                        </div>
                        <div class="faq-info__item">
                            <div class="faq-info__heading">{{ __($faqContent->data_values?->title_two ?? null) }}</div>
                            <a href="{{ url($faqContent->data_values?->button_two_link ?? null) }}" class="faq-info__link">{{ __($faqContent->data_values?->button_two_name ?? null) }}</a>
                            <svg class="faq-info__icon" width="42" height="88" viewBox="0 0 42 88" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_1218_1186)">
                                    <g style="mix-blend-mode:multiply">
                                        <path
                                              d="M55.2167 113.668C44.0909 107.135 42.3566 106.375 31.2631 103.173C23.5464 100.945 14.5433 95.3367 10.0084 89.9324C6.78368 86.0894 -0.30978 74.9796 0.0749368 74.3746C0.506915 73.6962 1.08575 73.9926 2.96251 75.8534C5.57678 78.4452 9.71678 80.7187 16.1687 83.1056C27.6209 87.3424 30.4344 89.1289 37.6429 96.7409C40.0079 99.2383 42.1982 101.402 42.5103 101.549C43.2721 101.908 37.8522 93.3331 35.5297 90.5059C34.5137 89.269 31.1173 85.908 27.9822 83.037C13.679 69.9388 7.30789 60.7004 3.5534 47.6143C1.59113 40.7748 1.96688 39.7641 4.85843 44.1039C6.44424 46.4839 11.1913 51.442 18.8909 58.7601C21.0648 60.8264 23.9851 64.2644 25.4514 66.4838L28.094 70.4836L26.5585 64.7616C25.4012 60.4489 24.6193 58.6161 23.3841 57.3202C15.7753 49.3376 15.6859 35.9344 23.0856 12.5601C24.1663 9.14658 25.2709 5.07474 25.5403 3.51155C26.0328 0.654248 26.5425 -0.1244 27.5881 0.383511C28.2695 0.714491 29.3946 7.37503 30.081 15.1412C30.647 21.5448 30.1534 28.198 28.1596 41.0414C26.508 51.6802 26.4548 56.3666 27.9148 62.5998C29.0685 67.5256 30.9312 73.5694 31.3597 73.7776C31.496 73.8438 31.4786 72.0662 31.321 69.8274C30.7504 61.7217 31.9591 54.9809 36.2474 42.352C37.4982 38.6681 38.9264 33.7879 39.4211 31.507C40.0061 28.8094 40.5787 27.2227 41.0594 26.9672C41.6295 26.6642 41.8249 26.9682 41.9148 28.2981C41.9788 29.2461 42.6034 34.078 43.3027 39.0357C45.0714 51.576 44.9698 54.145 42.2402 65.9246C41.0396 71.1059 40.3153 73.3923 38.48 77.7954C37.8937 79.2018 37.2293 81.5541 37.0035 83.0226C36.6288 85.4597 36.8135 86.0834 39.1211 90.1698C44.9805 100.546 48.7249 105.578 54.6826 111.084C59.1858 115.246 59.363 116.103 55.2167 113.668L55.2167 113.668Z"
                                              fill="currentColor" />
                                    </g>
                                </g>
                                <defs>
                                    <clipPath id="clip0_1218_1186">
                                        <rect width="42" height="88" fill="white" />
                                    </clipPath>
                                </defs>
                            </svg>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 ">
                <div class="accordion custom--accordion" id="accordionFaq">
                    @foreach ($faqElements ?? [] as $faqElement)
                        <div class="accordion-item wow fadeInUp" data-wow-duration="1s">
                            <h2 class="accordion-header" id="headingOne{{ $loop->iteration }}">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseOne{{ $loop->iteration }}" aria-expanded="true"
                                        aria-controls="collapseOne{{ $loop->iteration }}">
                                    {{ __($faqElement->data_values?->question ?? null) }}
                                </button>
                            </h2>
                            <div id="collapseOne{{ $loop->iteration }}"
                                 class="accordion-collapse collapse {{ $loop->first ? 'show' : null }}"
                                 aria-labelledby="headingOne{{ $loop->iteration }}" data-bs-parent="#accordionFaq">
                                <div class="accordion-body">
                                    <p class="text">
                                        {{ __($faqElement->data_values?->answer ?? null) }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
