@php
    $counterElements = getContent('counter.element', orderById: true);
@endphp
<div class="counter-up-section my-120">
    <div class="container">
        <div class="row">
            <div class="counterup-item ">
                @foreach ($counterElements ?? [] as $counterElement)
                    <div class="counterup-item__content wow fadeInUp" data-wow-duration="1s">
                        <div class="counterup-item__number">
                            <h3 class="counterup-item__title mb-0"><span class="odometer" data-odometer-final="{{ $counterElement->data_values?->counter_digit ?? 0 }}"> 0 </span>
                                {{ __($counterElement->data_values?->counter_type ?? null) }} </h3>
                        </div>
                        <span class="counterup-item__text mb-0"> {{ __($counterElement->data_values?->title ?? null) }} </span>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>


@push('style-lib')
    <link rel="stylesheet" href="{{ asset(activeTemplate(true) . 'css/odometer.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset(activeTemplate(true) . 'js/odometer.min.js') }}"></script>
    <script src="{{ asset(activeTemplate(true) . 'js/viewport.jquery.js') }}"></script>
@endpush
