@php
    $commandContent = getContent('command.content', true);
    $commandElements = getContent('command.element', orderById: true);
@endphp

<div class="command-section my-120">
    <div class="container">
        <div class="row gy-4 justify-content-between">
            <div class="col-lg-6">
                <div class="section-heading style-left">
                    <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                        @include('Template::partials.star_svg')
                        {{ __($commandContent->data_values?->heading ?? null) }}
                    </span>
                    <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                        {{ __($commandContent->data_values?->subheading ?? null) }}
                    </h2>
                    <p class="section-heading__desc wow fadeInUp" data-wow-duration="1s">
                        {{ __($commandContent->data_values?->content ?? null) }}
                    </p>
                </div>
                <div class="command-content">
                    <div class="command-list accordion" id="commentAccordion">
                        @foreach ($commandElements ?? [] as $key => $commandElement)
                            <div class="command-item {{ $loop->first ? 'active' : null }}">
                                <div class="command-item__content">
                                    <h5 class="command-item__title" data-bs-toggle="collapse"
                                        data-bs-target="#commandCollapse-{{ $key }}" aria-expanded="false"
                                        aria-controls="commandCollapse-{{ $key }}">
                                        {{ __($commandElement->data_values?->title ?? null) }}
                                    </h5>
                                    <div class="collapse {{ $loop->first ? 'show' : null }}"
                                         id="commandCollapse-{{ $key }}" data-bs-parent="#commentAccordion">
                                        <p class="command-item__desc">
                                            {{ __($commandElement->data_values?->description ?? null) }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="col-lg-6 ps-lg-5">
                <div class="command-wrapper wow fadeInUp" data-wow-duration="1s">
                    <div class="command-thumb">
                        <img src="{{ frontendImage('command', $commandContent->data_values?->image ?? null, '600x445') }}"
                             alt="@lang('image')">
                    </div>
                    <div class="command-wrapper__shape"></div>
                </div>
            </div>
        </div>
    </div>
</div>
