<div class="col-xl-4 col-sm-6 plan-col">
    <div class="pricing-card {{ auth()->check() && auth()->user()->plan_id == $plan->id ? 'active' : '' }}">
        <div class="pricing-card__top">
            <div class="pricing-card__icon">
                <svg width="50" height="46" viewBox="0 0 50 46" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                          d="M7.15648 18.4462C7.37791 18.432 7.59074 18.3551 7.77019 18.2246C7.94963 18.0941 8.0883 17.9153 8.17006 17.709L9.0224 15.5644L9.87474 17.709C9.95648 17.9153 10.0952 18.0941 10.2746 18.2246C10.454 18.3551 10.6669 18.432 10.8883 18.4462L13.1919 18.5937L11.4181 20.0665C11.2467 20.2079 11.1189 20.3949 11.0496 20.606C10.9803 20.817 10.9723 21.0434 11.0265 21.2589L11.5978 23.4943L9.64896 22.26C9.46153 22.1413 9.24425 22.0783 9.0224 22.0783C8.80055 22.0783 8.58326 22.1413 8.39584 22.26L6.44691 23.4943L7.0183 21.2589C7.07331 21.0439 7.06615 20.8177 6.99764 20.6066C6.92912 20.3955 6.80208 20.2082 6.63129 20.0665L4.85287 18.5937L7.15648 18.4462ZM0.720153 17.2502C0.647399 17.4736 0.643658 17.7138 0.709418 17.9394C0.775178 18.165 0.907387 18.3655 1.08881 18.5148L4.56263 21.3967L3.4431 25.7726C3.386 26 3.39828 26.2393 3.47838 26.4597C3.55849 26.6802 3.70273 26.8715 3.89255 27.0092C4.08236 27.147 4.30906 27.2247 4.54344 27.2324C4.77782 27.2402 5.00915 27.1776 5.20765 27.0527L9.0224 24.6367L12.8371 27.0527C13.0355 27.1785 13.2671 27.2417 13.5019 27.2343C13.7367 27.227 13.9638 27.1493 14.1539 27.0113C14.344 26.8734 14.4884 26.6816 14.5682 26.4607C14.6481 26.2398 14.6598 26 14.6018 25.7724L13.4822 21.3965L16.9606 18.5146C17.1405 18.3645 17.2714 18.1639 17.3363 17.9387C17.4013 17.7135 17.3973 17.474 17.325 17.251C17.2526 17.0281 17.1152 16.8319 16.9303 16.6878C16.7455 16.5437 16.5218 16.4581 16.2879 16.4423L11.7774 16.1543L10.1143 11.9569C10.0275 11.7389 9.87724 11.5518 9.68298 11.4201C9.48873 11.2883 9.25941 11.2179 9.02469 11.2179C8.78998 11.2179 8.56066 11.2883 8.3664 11.4201C8.17215 11.5518 8.0219 11.7389 7.93509 11.9569L6.26722 16.1543L1.76136 16.4422C1.52691 16.4572 1.30235 16.5422 1.11672 16.6861C0.931095 16.8301 0.792949 17.0265 0.720153 17.2499V17.2502ZM43.3692 20.0665C43.1975 20.2075 43.0698 20.3948 43.0013 20.6061C42.9327 20.8174 42.926 21.0439 42.9822 21.2589L43.5535 23.4943L41.6046 22.26C41.417 22.1416 41.1999 22.0785 40.9781 22.078C40.7561 22.0772 40.5385 22.1404 40.3515 22.26L38.4026 23.4943L38.969 21.2589C39.0252 21.0439 39.0186 20.8174 38.95 20.606C38.8815 20.3947 38.7537 20.2075 38.582 20.0665L36.8082 18.5937L39.1119 18.4462C39.3333 18.432 39.5461 18.3551 39.7256 18.2246C39.905 18.0941 40.0437 17.9153 40.1254 17.709L40.9778 15.5644L41.8262 17.709C41.9095 17.9151 42.0492 18.0936 42.2293 18.224C42.4093 18.3544 42.6225 18.4314 42.8444 18.4462L45.148 18.5937L43.3692 20.0665ZM49.2802 17.2502C49.2074 17.0268 49.0693 16.8304 48.8837 16.6864C48.698 16.5424 48.4735 16.4574 48.239 16.4425L43.7331 16.1546L42.0654 11.9569C41.9786 11.7389 41.8283 11.5518 41.6341 11.4201C41.4398 11.2883 41.2105 11.2179 40.9758 11.2179C40.741 11.2179 40.5117 11.2883 40.3175 11.4201C40.1232 11.5518 39.973 11.7389 39.8862 11.9569L38.2183 16.1543L33.7124 16.4422C33.4786 16.4581 33.2549 16.5436 33.07 16.6877C32.8852 16.8318 32.7478 17.028 32.6754 17.2509C32.603 17.4739 32.5991 17.7134 32.664 17.9386C32.729 18.1638 32.8598 18.3644 33.0398 18.5146L36.5183 21.3964L35.3987 25.7723C35.3407 25.9999 35.3524 26.2397 35.4322 26.4606C35.5121 26.6815 35.6564 26.8733 35.8465 27.0112C36.0366 27.1492 36.2638 27.2269 36.4986 27.2342C36.7333 27.2416 36.9649 27.1784 37.1633 27.0526L40.9781 24.6366L44.7928 27.0526C44.9907 27.178 45.2217 27.2411 45.4558 27.2336C45.6899 27.2261 45.9164 27.1484 46.1059 27.0106C46.2965 26.8733 46.4411 26.6816 46.5209 26.4606C46.6006 26.2396 46.6117 25.9997 46.5528 25.7723L45.4332 21.3964L48.9117 18.5146C49.0922 18.3645 49.2238 18.164 49.2894 17.9386C49.3551 17.7133 49.3519 17.4734 49.2802 17.2499V17.2502ZM28.0595 10.9719C27.8881 11.1132 27.7604 11.3003 27.691 11.5114C27.6217 11.7224 27.6137 11.9488 27.6679 12.1643L28.5157 15.4787L25.6269 13.6487C25.4392 13.5302 25.222 13.4671 25 13.4667C24.7781 13.4665 24.5608 13.5297 24.3735 13.6487L21.4801 15.4787L22.3279 12.1643C22.384 11.9493 22.3774 11.7228 22.3088 11.5115C22.2402 11.3001 22.1125 11.1129 21.9409 10.9719L19.3103 8.78809L22.7243 8.56924C22.9457 8.55548 23.1586 8.47892 23.3381 8.34854C23.5176 8.21815 23.6563 8.03933 23.7378 7.83301L25 4.65312L26.2624 7.83301C26.344 8.03933 26.4826 8.21815 26.6621 8.34854C26.8416 8.47892 27.0546 8.55548 27.276 8.56924L30.6899 8.78809L28.0592 10.9719H28.0595ZM34.8229 7.44512C34.8964 7.66791 34.901 7.90772 34.8361 8.13317C34.7712 8.35863 34.6397 8.55925 34.4589 8.70879L30.1236 12.3016L31.5201 17.7569C31.5781 17.9846 31.5664 18.2244 31.4866 18.4453C31.4067 18.6662 31.2624 18.8581 31.0723 18.996C30.8822 19.134 30.655 19.2117 30.4202 19.219C30.1854 19.2264 29.9538 19.1631 29.7554 19.0373L25 16.0256L20.2408 19.0373C20.0551 19.1561 19.8392 19.2191 19.6188 19.2188C19.44 19.2192 19.2634 19.1787 19.1027 19.1004C18.942 19.022 18.8013 18.9079 18.6915 18.7668C18.5816 18.6257 18.5056 18.4613 18.469 18.2863C18.4325 18.1113 18.4365 17.9302 18.4808 17.7569L19.8768 12.3016L15.5414 8.70879C15.3603 8.55934 15.2282 8.35883 15.1625 8.13335C15.0968 7.90786 15.1005 7.66782 15.1731 7.44444C15.2456 7.22107 15.3837 7.02469 15.5694 6.88085C15.755 6.737 15.9797 6.65235 16.2141 6.63789L21.8349 6.27851L23.9127 1.04609C23.9989 0.82802 24.1487 0.640902 24.3426 0.509041C24.5365 0.37718 24.7655 0.306671 25 0.306671C25.2345 0.306671 25.4636 0.37718 25.6575 0.509041C25.8514 0.640902 26.0012 0.82802 26.0873 1.04609L28.1652 6.27851L33.786 6.63789C34.0199 6.65266 34.2439 6.73759 34.4288 6.88158C34.6137 7.02558 34.751 7.22196 34.8226 7.44512H34.8229ZM34.3848 43.3516C34.6603 41.8033 35.4719 40.4014 36.6773 39.3915C37.8828 38.3817 39.4052 37.8282 40.9777 37.8282C42.5503 37.8282 44.0727 38.3817 45.2781 39.3915C46.4836 40.4014 47.2951 41.8033 47.5706 43.3516H34.3848ZM15.7578 38.5029C16.76 36.9651 18.1301 35.7016 19.744 34.827C21.3578 33.9524 23.1644 33.4944 24.9999 33.4944C26.8355 33.4944 28.6421 33.9524 30.2559 34.827C31.8698 35.7016 33.2398 36.9651 34.242 38.5029C33.0265 39.8566 32.2505 41.5473 32.0167 43.3516H17.9834C17.7496 41.5473 16.9737 39.8566 15.7581 38.5029H15.7578ZM2.42943 43.3516C2.70493 41.8033 3.51651 40.4014 4.72195 39.3915C5.92739 38.3817 7.44979 37.8282 9.02235 37.8282C10.5949 37.8282 12.1173 38.3817 13.3227 39.3915C14.5282 40.4014 15.3398 41.8033 15.6153 43.3516H2.42943ZM9.0224 29.7509C9.58942 29.7507 10.1438 29.9187 10.6153 30.2336C11.0868 30.5485 11.4544 30.9962 11.6715 31.52C11.8886 32.0438 11.9454 32.6202 11.8349 33.1764C11.7243 33.7325 11.4513 34.2434 11.0504 34.6443C10.6495 35.0453 10.1387 35.3184 9.58255 35.429C9.02643 35.5396 8.44999 35.4828 7.92614 35.2658C7.4023 35.0488 6.95458 34.6813 6.63961 34.2098C6.32464 33.7383 6.15658 33.184 6.15668 32.617C6.15861 31.8575 6.46114 31.1297 6.99814 30.5926C7.53514 30.0555 8.26292 29.7529 9.0224 29.7509ZM19.9092 26.0595C19.9091 25.0525 20.2077 24.0682 20.767 23.2309C21.3264 22.3937 22.1215 21.7411 23.0518 21.3557C23.982 20.9703 25.0057 20.8694 25.9933 21.0659C26.9809 21.2623 27.888 21.7471 28.6001 22.4591C29.3121 23.1711 29.797 24.0783 29.9934 25.0658C30.1899 26.0534 30.089 27.0771 29.7037 28.0074C29.3184 28.9377 28.6658 29.7328 27.8285 30.2922C26.9913 30.8516 26.007 31.1501 25 31.1501C23.6505 31.1483 22.3567 30.6114 21.4024 29.6571C20.4481 28.7029 19.9111 27.409 19.9092 26.0595ZM40.9781 29.7509C41.5449 29.7516 42.0988 29.9204 42.5697 30.2358C43.0406 30.5513 43.4075 30.9993 43.6239 31.5232C43.8402 32.0471 43.8964 32.6233 43.7854 33.1792C43.6743 33.735 43.401 34.2454 42.9999 34.646C42.5988 35.0465 42.0879 35.3191 41.5319 35.4293C40.9759 35.5396 40.3997 35.4825 39.8762 35.2654C39.3526 35.0482 38.9051 34.6807 38.5904 34.2093C38.2756 33.7379 38.1077 33.1838 38.1077 32.617C38.1086 31.8564 38.4115 31.1273 38.9497 30.5898C39.4879 30.0524 40.2175 29.7506 40.9781 29.7509ZM44.6778 36.2812C45.4008 35.5507 45.8916 34.6225 46.0883 33.6136C46.2849 32.6047 46.1786 31.5602 45.7828 30.6116C45.387 29.663 44.7194 28.8526 43.864 28.2827C43.0087 27.7127 42.0037 27.4086 40.9759 27.4086C39.948 27.4086 38.9431 27.7127 38.0877 28.2827C37.2323 28.8526 36.5647 29.663 36.1689 30.6116C35.7731 31.5602 35.6668 32.6047 35.8635 33.6136C36.0601 34.6225 36.5509 35.5507 37.274 36.2812C36.8423 36.4763 36.4264 36.7046 36.03 36.9641C34.4464 34.6512 32.1753 32.8952 29.5384 31.9445C30.7683 30.9971 31.6707 29.6884 32.1193 28.2021C32.5678 26.7159 32.5399 25.1265 32.0394 23.6568C31.539 22.1872 30.5911 20.9111 29.3288 20.0074C28.0664 19.1037 26.5528 18.6178 25.0003 18.6178C23.4478 18.6178 21.9343 19.1037 20.6719 20.0074C19.4095 20.9111 18.4617 22.1872 17.9612 23.6568C17.4608 25.1265 17.4329 26.7159 17.8814 28.2021C18.3299 29.6884 19.2324 30.9971 20.4622 31.9445C17.8247 32.8963 15.5525 34.652 13.9661 36.9641C13.5718 36.7037 13.1574 36.4753 12.7266 36.2812C13.4512 35.5504 13.9433 34.6215 14.1408 33.6115C14.3384 32.6014 14.2326 31.5555 13.8367 30.6056C13.4408 29.6556 12.7726 28.844 11.9163 28.2732C11.06 27.7023 10.0539 27.3977 9.02469 27.3977C7.99554 27.3977 6.98941 27.7023 6.13308 28.2732C5.27676 28.844 4.60857 29.6556 4.2127 30.6056C3.81683 31.5555 3.711 32.6014 3.90855 33.6115C4.10609 34.6215 4.59818 35.5504 5.32279 36.2812C3.82529 36.9536 2.53917 38.0211 1.60249 39.3691C0.665807 40.7172 0.113927 42.2948 0.00609026 43.9328C-0.0107788 44.1587 0.0198615 44.3857 0.0960375 44.5991C0.172213 44.8125 0.292236 45.0075 0.448375 45.1717C0.602557 45.3375 0.789393 45.4696 0.997125 45.5597C1.20486 45.6498 1.42898 45.6959 1.65541 45.6951H48.3449C48.5713 45.6959 48.7954 45.6498 49.0032 45.5597C49.2109 45.4696 49.3978 45.3375 49.552 45.1717C49.7081 45.0075 49.8281 44.8124 49.9043 44.5991C49.9805 44.3857 50.0111 44.1587 49.9943 43.9328C49.8855 42.2951 49.3333 40.7179 48.3968 39.37C47.4602 38.0221 46.1747 36.9544 44.6778 36.2812Z"
                          fill="currentColor" />
                </svg>
            </div>
            <h4 class="pricing-card__title"> {{ __($plan->name) }} </h4>

            <h2 class="pricing-card__value monthly-price">{{ gs('cur_sym') }}{{ showAmount($plan->monthly_price, currencyFormat: false) }}<sub class="text">/ @lang('Month')</sub></h2>
            <h2 class="pricing-card__value yearly-price d-none">{{ gs('cur_sym') }}{{ showAmount($plan->yearly_price, currencyFormat: false) }}<sub class="text">/ @lang('Year')</sub></h2>

            <p class="pricing-card__desc monthly-credit">
                @lang('Connect up to') <span class="fw-semibold">{{ getAmount($plan->monthly_total_channel) }}</span> @lang('channels')
            </p>
            <p class="pricing-card__desc yearly-credit d-none">
                @lang('Connect up to') <span class="fw-semibold">{{ getAmount($plan->yearly_total_channel) }}</span> @lang('channels')
            </p>

        </div>
        <div class="pricing-card__bottom wow fadeInUp" data-wow-duration="1s">
            @auth
                <button class="btn card-btn subscribeBtn" data-plan_id="{{ $plan->id }}" type="submit">
                    @lang('Subscribe')
                </button>
            @else
                <button class="btn card-btn loginBtn" type="button">
                    @lang('Subscribe')
                </button>
            @endauth

        </div>
        <div class="pricing-card__content wow fadeInUp" data-wow-duration="1s">
            <h5 class="title"> @lang('What\'s included') </h5>
            <ul class="text-list">
                <li class="monthly-post text-list__item">
                    <span class="text-list__icon">
                        <i class="fas fa-check"></i>
                    </span>
                    @lang('Up to') {{ getAmount($plan->monthly_total_post_schedule) }} @lang('scheduled posts')
                </li>
                <li class="yearly-post text-list__item d-none">
                    <span class="text-list__icon">
                        <i class="fas fa-check"></i>
                    </span>
                    @lang('Up to') {{ getAmount($plan->yearly_total_post_schedule) }} @lang('scheduled posts')
                </li>

                @if ($plan->ai_assistant == Status::ENABLE)
                    <li class="text-list__item">
                        <span class="text-list__icon">
                            <i class="fas fa-check"></i>
                        </span>
                        @lang('AI Assistant with High Accuracy')
                    </li>
                @endif
                @foreach ($plan->features ?? [] as $feature)
                    <li class="text-list__item">
                        <span class="text-list__icon">
                            <i class="fas fa-check"></i>
                        </span>
                        {{ __($feature) }}
                    </li>
                @endforeach
            </ul>
        </div>

    </div>
</div>
