@php
    $socialContents = getContent('social_icon.element', orderById: true)->pluck('data_values') ?? [];
    $policyPages = getContent('policy_pages.element', orderById: true);
    $footerContent = getContent('footer.content', true)->data_values ?? null;
    $contactContent = getContent('contact_us.content', true);
@endphp
<footer class="footer-area">
    <div class="footer-area__top">
        <div class="container">
            <div class="footer-area__top-inner">
                <h1 class="title wow fadeInUp" data-wow-duration="1s">
                    {{ __($footerContent->heading ?? null) }}
                </h1>
                <a href="{{ url($footerContent->button_url ?? null) }}" class="top-btn wow fadeInUp"
                   data-wow-duration="1s">
                    <span class="top-btn__icon">
                        <i class="fa-solid fa-arrow-up-long"></i>
                    </span>
                    {{ __($footerContent->button_name ?? null) }}
                </a>
            </div>
        </div>
    </div>

    <div class="footer-wedged">
        <div class="container">
            <div class="footer-item-wrapper">
                <div class="footer-item">
                    <h5 class="footer-item__title wow fadeInUp" data-wow-duration="1s">
                        <figure class="footer-item__logo">
                            <img src="{{ siteLogo() }}" alt="@lang('logo')">
                        </figure>
                    </h5>
                    <p class="footer-item__desc wow fadeInUp" data-wow-duration="1s">
                        {{ __($footerContent->content ?? null) }}
                    </p>
                    <ul class="social-list">
                        @foreach ($socialContents as $socialContent)
                            <li class="social-list__item wow fadeInUp" data-wow-duration="1s">
                                <a href="{{ $socialContent->url ?? '' }}" target="_blank"
                                   class="social-list__link flex-center">
                                    @php echo $socialContent->social_icon ?? ""; @endphp
                                    {{ __($socialContent->title ?? '') }}
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
                <div class="footer-item">
                    <h5 class="footer-item__title wow fadeInUp" data-wow-duration="1s"> @lang('Quick Links') </h5>
                    <ul class="footer-menu">
                        <li class="footer-menu__item wow fadeInUp" data-wow-duration="1s">
                            <a href="{{ route('home') }}" class="footer-menu__link"> @lang('Home') </a>
                        </li>
                        <li class="footer-menu__item wow fadeInUp" data-wow-duration="1s">
                            <a href="{{ route('plans') }}" class="footer-menu__link"> @lang('Plan') </a>
                        </li>
                        <li class="footer-menu__item wow fadeInUp" data-wow-duration="1s">
                            <a href="{{ route('blog') }}" class="footer-menu__link"> @lang('Blog') </a>
                        </li>
                        <li class="footer-menu__item wow fadeInUp" data-wow-duration="1s">
                            <a href="{{ route('contact') }}" class="footer-menu__link"> @lang('Contact') </a>
                        </li>
                    </ul>
                </div>
                <div class="footer-item">
                    <h5 class="footer-item__title wow fadeInUp" data-wow-duration="1s"> @lang('Policy') </h5>
                    <ul class="footer-menu">
                        @foreach ($policyPages as $policyPage)
                            <li class="footer-menu__item wow fadeInUp" data-wow-duration="1s"><a
                                   href="{{ route('policy.pages', $policyPage?->slug) }}" class="footer-menu__link">
                                    {{ __($policyPage?->data_values?->title ?? '') }} </a></li>
                        @endforeach
                        <li class="footer-menu__item wow fadeInUp" data-wow-duration="1s"><a
                               href="{{ route('cookie.policy') }}" class="footer-menu__link">
                                @lang('Cookie Policy') </a></li>
                    </ul>
                </div>
                <div class="footer-item">
                    <h5 class="footer-item__title wow fadeInUp" data-wow-duration="1s">
                        @lang('Contact Info')
                    </h5>

                    <div class="footer-contact">
                        <div class="footer-contact__info">
                            <span class="icon">
                                <i class="fas fa-map-marked"></i> </span>
                            <span class="text">{{ __($contactContent->data_values->contact_details ?? null) }}</span>
                        </div>
                        <div class="footer-contact__info">
                            <span class="icon">
                                <i class="fas fa-phone-volume"></i> </span>
                            <a href="tel:{{ $contactContent->data_values->contact_number ?? null }}" class="text">
                                {{ $contactContent->data_values->contact_number ?? null }}
                            </a>
                        </div>
                        <div class="footer-contact__info">
                            <span class="icon">
                                <i class="fas fa-envelope-open"></i> </span>
                            <a href="mailto:{{ $contactContent->data_values->email_address ?? null }}" class="text nowrap-lg">
                                {{ $contactContent->data_values->email_address ?? null }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer Top End-->

    <!-- bottom Footer -->
    <div class="bottom-footer py-3">
        <div class="container">
            <div class="row gy-3">
                <div class="col-md-12 text-center">
                    <div class="bottom-footer-text text-white wow fadeInUp" data-wow-duration="1s">@lang('Copyright')
                        &copy; {{ date('Y') }} {{ gs('site_name') }}. @lang('All Rights Reserved.')</div>
                </div>
            </div>
        </div>
    </div>
</footer>
