@extends('Template::layouts.frontend')
@section('content')
    @php
        $blogContent = getContent('blog.content', true);
    @endphp

    <div class="blog-section my-120">
        <div class="container">
            <div class="row gy-4 justify-content-center">
                @foreach ($blogs as $blog)
                    <div class="col-lg-4 col-md-6 col-sm-6 blog-col wow fadeInUp" data-wow-duration="1s">
                        <div class="blog-item">
                            <div class="blog-item__thumb">
                                <a href="{{ route('blog.details', $blog->slug) }}" class="blog-item__thumb-link">
                                    <img class="image1"
                                         src="{{ frontendImage('blog', 'thumb_' . ($blog->data_values->image ?? null), '420x305') }}"
                                         alt="@lang('image')">
                                    <img class="image2"
                                         src="{{ frontendImage('blog', 'thumb_' . ($blog->data_values->image ?? null), '420x305') }}"
                                         alt="@lang('image')">
                                </a>
                            </div>
                            <div class="blog-item__content">
                                <span class="blog-item__date"><i class="fa-solid fa-clock"></i> {{ showDateTime($blog->created_at, 'd M, Y') }} </span>
                                <h5 class="blog-item__title">
                                    <a href="{{ route('blog.details', $blog->slug) }}" class="blog-item__title-link">
                                        {{ __($blog->data_values->title ?? null) }}
                                    </a>
                                </h5>

                                <a href="{{ route('blog.details', $blog->slug) }}" class="blog-item__btn">
                                    @lang('Read More')
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            @if ($blogs->hasPages())
                <div class="wow fadeInUp pagination-wrapper">
                    {{ paginateLinks($blogs) }}
                </div>
            @endif

        </div>
    </div>


    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include('Template::sections.' . $sec)
        @endforeach
    @endif
@endsection
