@extends('admin.layouts.app')

@section('panel')
    <div class="doc-container">
        <div class="row gy-4">
            <div class="col-xl-3">
                <div class="doc-sidebar">
                    <h5>@lang('Table of Contents')</h5>
                    <nav class="nav flex-column">
                        <a class="nav-link active" href="#overview">@lang('Overview')</a>
                        <a class="nav-link" href="#prerequisites">@lang('Prerequisites')</a>
                        <a class="nav-link" href="#create-project">@lang('Create Google Project')</a>
                        <a class="nav-link" href="#enable-api">@lang('Enable YouTube API')</a>
                        <a class="nav-link" href="#configure-oauth">@lang('Configure OAuth Credentials')</a>
                        <a class="nav-link" href="#scope">@lang('Set Scope')</a>
                        <a class="nav-link" href="#troubleshooting">@lang('Troubleshooting')</a>
                    </nav>
                </div>
            </div>

            <div class="col-xl-9">
                <div class="doc-content">
                    <section id="overview" class="doc-section">
                        <h2>@lang('Overview')</h2>
                        <p>@lang('This documentation will guide you through the process of creating and configuring a Google Cloud Project to integrate YouTube features into your application. You\'ll learn how to enable the YouTube Data API, configure OAuth 2.0 consent screen, generate credentials, and properly set up your project for production use.')</p>

                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Important:')</strong> @lang('YouTube API integration requires a Google Cloud Project with OAuth 2.0 credentials. Your application will need to go through verification if requesting sensitive or restricted scopes.')
                        </div>
                    </section>

                    <section id="prerequisites" class="doc-section">
                        <h2>@lang('Prerequisites')</h2>
                        <p>
                            @lang('Before creating and configuring a YouTube API integration, ensure the following requirements are met. These are mandatory to avoid project creation issues, permission rejections, or verification failures.')
                        </p>

                        <div class="requirements-list">
                            <ul>
                                <li>
                                    <strong>@lang('Google Account')</strong><br>
                                    @lang('A valid Google account with a confirmed email address.')
                                </li>

                                <li>
                                    <strong>@lang('YouTube Channel')</strong><br>
                                    @lang('At least one YouTube channel associated with your Google account for testing purposes.')
                                </li>

                                <li>
                                    <strong>@lang('Verified Website Domain')</strong><br>
                                    @lang('A valid website with a publicly accessible domain for OAuth redirect URIs.')
                                </li>

                                <li>
                                    <strong>@lang('Privacy Policy URL (Required)')</strong><br>
                                    @lang('A publicly accessible privacy policy page explaining how user data is collected, used, and stored.')
                                </li>

                                <li>
                                    <strong>@lang('Terms of Service URL (Required for Verification)')</strong><br>
                                    @lang('A clear Terms of Service page describing user responsibilities and platform usage.')
                                </li>

                                <li>
                                    <strong>@lang('Application Use-Case Description')</strong><br>
                                    @lang('A clear explanation of how the application uses YouTube data and API scopes. This is required during OAuth verification.')
                                </li>

                                <li>
                                    <strong>@lang('Secure Website (HTTPS)')</strong><br>
                                    @lang('The application website must use HTTPS. HTTP URLs are not accepted for OAuth redirect URIs.')
                                </li>

                                <li>
                                    <strong>@lang('Google Cloud Console Access')</strong><br>
                                    @lang('Access to Google Cloud Console to create projects and manage APIs.')
                                </li>
                            </ul>
                        </div>
                    </section>

                    <section id="create-project" class="doc-section">
                        <h2>@lang('Step 1: Create a Google Cloud Project')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Navigate to Google Cloud Console')</div>
                                    <p>
                                        @lang('Go to')
                                        <a href="https://console.cloud.google.com" target="_blank">https://console.cloud.google.com</a>
                                        @lang('and sign in with your Google account.')
                                    </p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/youtube/01.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/01.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Create New Project')</div>
                                    <p>
                                        @lang('Click the ') <strong>@lang('Select a project')</strong> @lang('button and then the') <strong>@lang('"New Project"')</strong> @lang('button and create a new project.')
                                    </p>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/02.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/02.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/03.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/03.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Fill in Project Details')</div>

                                    <p>
                                        @lang('Provide the required information to complete the project creation. Follow the steps below carefully:')
                                    </p>

                                    <ul class="app-details-list">
                                        <li>
                                            <strong>@lang('Project Name:')</strong>
                                            @lang('Enter a unique and descriptive name for your project.')
                                        </li>

                                        <li>
                                            <strong>@lang('Organization:')</strong>
                                            @lang('Select an organization if applicable, or leave as "No organization".')
                                        </li>

                                        <li>
                                            <strong>@lang('Location:')</strong>
                                            @lang('Choose the appropriate location for your project resources.')
                                        </li>

                                        <li>
                                            <strong>@lang('Create:')</strong>
                                            @lang('Click the "Create" button to finalize project creation.')
                                        </li>
                                    </ul>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/youtube/04.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/04.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="alert-success-custom">
                            <strong>
                                <i class="fas fa-check-circle me-2"></i>@lang('Success!')
                            </strong>
                            @lang('Your Google Cloud Project has been created. You can now enable the YouTube Data API.')

                        </div>
                    </section>

                    <section id="enable-api" class="doc-section">
                        <h2>@lang('Step 2: Enable YouTube Data API v3')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Navigate to APIs & Services')</div>
                                    <p>@lang('From the navigation menu, go to') <strong>@lang('APIs & Services > Library')</strong>.</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/youtube/05.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/05.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Search for YouTube Data API')</div>
                                    <p>@lang('In the API Library, search for') <strong>@lang('"YouTube Data API v3"')</strong> @lang('and click on it').</p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/youtube/06.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/06.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Enable the API')</div>
                                    <p>
                                        @lang('Click the') <strong>@lang('"Enable"')</strong> @lang('button to activate YouTube Data API v3 for your project.')
                                    </p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/youtube/07.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/07.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Note:')</strong> @lang('After enabling the API, you may need to wait a few minutes for it to become fully active.')
                        </div>
                    </section>

                    <section id="configure-oauth" class="doc-section">
                        <h2>@lang('Step 3: Configure OAuth Consent Screen')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Access OAuth Consent Screen')</div>
                                    <p>@lang('Navigate to') <strong>@lang('APIs & Services > OAuth consent screen')</strong> @lang('from the left menu.')</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/youtube/08.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/08.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Fill OAuth Consent Information')</div>

                                    <p>@lang('Complete the required fields on the OAuth consent screen:')</p>

                                    <ul class="app-details-list">
                                        <li>
                                            <strong>@lang('Get Start:')</strong>
                                            @lang('Click the "Get Started" button.')
                                        </li>

                                        <li>
                                            <strong>@lang('App Name:')</strong>
                                            @lang('Enter your application name.')
                                        </li>

                                        <li>
                                            <strong>@lang('Audience:')</strong>
                                            @lang('Select "External" as the audience.')
                                        </li>

                                        <li>
                                            <strong>@lang('Developer Contact Email:')</strong>
                                            @lang('Add your contact email for Google communications.')
                                        </li>
                                    </ul>
                                    <p>@lang('Click') <strong>@lang('"Create"')</strong> @lang('button').</p>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/09.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/09.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/10.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/10.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/11.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/11.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Get oAuth Credentials')</div>

                                    <p>@lang('Navigate to') <strong>@lang('APIs & Services > Credentials')</strong> @lang('from the left menu.')</p>
                                    <p>@lang('Click') <strong>@lang('"Create Credentials"')</strong> @lang('button.')</p>
                                    <p>@lang('Select') <strong>@lang('"OAuth client ID"')</strong></p>
                                    <p>@lang('select Application type as') <strong>@lang('"Web application"')</strong></p>
                                    <p>@lang('Enter a name for your OAuth Client ID')</p>
                                    <div class="mb-3">
                                        <p>@lang('The callback URL should be:')</p>
                                        <div class="callback-link">
                                            <code>{{ route('user.social.connect.callback', 'youtube') }}</code>
                                            <button class="copy-btn">
                                                <i class="las la-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <p>@lang('Click') <strong>@lang('"Create"')</strong> @lang('button').</p>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/12.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/12.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/13.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/13.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/14.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/14.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/15.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/15.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/16.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/16.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/17.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/17.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/19.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/19.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">4</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Copy and Save the OAuth Client ID')</div>

                                    <p>@lang('Copy the OAuth Client ID and Client Secret from the modal and save them securely for next time use.') </p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/youtube/18.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/18.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">5</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Get API Key')</div>
                                    <p>@lang('Click') <strong>@lang('"Create Credentials"')</strong> @lang('button.')</p>
                                    <p>@lang('Select') <strong>@lang('"API key"')</strong></p>
                                    <p>@lang('Enter a name for your API key')</p>
                                    <p>@lang('Click') <strong>@lang('"Create"')</strong> @lang('button').</p>
                                    <p>@lang('Copy the API key and save it for next time use')</p>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/20.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/20.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/21.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/21.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/22.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/22.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">6</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Setup All Credentials in Your Web Application')</div>
                                    <p>@lang('Add the API key, Client Secret and OAuth Client ID in your web application')</p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/youtube/23.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/23.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="alert-success-custom">
                            <strong>
                                <i class="fas fa-check-circle me-2"></i>@lang('Success!')
                            </strong>
                            @lang('Your YouTube API integration is now configured.')
                        </div>

                    </section>

                    <section id="scope" class="doc-section">
                        <h2>@lang('Step 4: Add Required Scopes')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">4</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Add Scopes')</div>
                                    <p>
                                        @lang('Click') <strong>@lang('Add or Remove Scopes')</strong>. @lang('Select the following YouTube scopes:')
                                    </p>

                                    <div class="mt-3">
                                        <span class="permission-badge">auth/youtube</span>
                                        <span class="permission-badge">auth/youtube.readonly</span>
                                        <span class="permission-badge">auth/youtube.force-ssl</span>
                                    </div>

                                    <p class="mt-3">@lang('Click') <strong>@lang('Update')</strong> @lang('then') <strong>@lang('Save')</strong>.</p>
                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/24.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/24.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/youtube/25.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/youtube/25.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong> @lang('Your OAuth consent screen must be verified by Google if you want to remove the "unverified app" warning for users. This requires submitting your app for verification.')
                        </div>

                    </section>

                    <section id="troubleshooting" class="doc-section">
                        <h2>@lang('Troubleshooting')</h2>

                        <h3>@lang('Common Issues and Solutions')</h3>

                        <div class="step-card">
                            <div class="step-title">@lang('Redirect URI Mismatch Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Error 400: redirect_uri_mismatch')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Ensure your redirect URI in the application exactly matches the one configured in Google Cloud Console. Check for:'):</p>
                            <ul class="app-details-list">
                                <li>@lang('Trailing slashes')</li>
                                <li>@lang('HTTP vs HTTPS')</li>
                                <li>@lang('Correct domain spelling')</li>
                            </ul>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Access Not Configured Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Access Not Configured. YouTube Data API has not been used in project')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Make sure you have enabled the YouTube Data API v3 in your project. Go to APIs & Services > Library and enable it.')
                            </p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Unverified App Warning')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Users see "This app isn\'t verified" warning during OAuth')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('This is normal during development. For production:'):</p>
                            <ul class="app-details-list">
                                <li>@lang('Add test users in OAuth consent screen')</li>
                                <li>@lang('Submit your app for verification')</li>
                                <li>@lang('Complete the verification process with Google')</li>
                            </ul>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Quota Exceeded Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('quotaExceeded error when making API calls')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('YouTube Data API has daily quota limits. Monitor your usage in the Cloud Console and request quota increase if needed.')
                            </p>
                        </div>

                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong> @lang('Without completing the OAuth verification process, users may see an "unverified app" warning. However, you and your test users can still use the integration. For production use with unrestricted access, you must complete Google\'s verification process.')
                        </div>

                        <h3>@lang('Useful Resources')</h3>
                        <div class="requirements-list">
                            <ul>
                                <li><a href="https://developers.google.com/youtube/v3" target="_blank">@lang('YouTube Data API Documentation')</a></li>
                                <li><a href="https://console.cloud.google.com" target="_blank">@lang('Google Cloud Console')</a></li>
                                <li><a href="https://developers.google.com/youtube/v3/guides/quota_and_compliance_audits" target="_blank">@lang('Quota and Compliance Guidelines')</a></li>
                                <li><a href="https://support.google.com/cloud/answer/9110914" target="_blank">@lang('OAuth Verification Process')</a></li>
                                <li><a href="https://developers.google.com/youtube/v3/getting-started" target="_blank">@lang('Getting Started with YouTube API')</a></li>
                            </ul>
                        </div>
                    </section>

                    <div class="text-center mt-5 pt-4 border-top">
                        <p class="text-muted">@lang('Last Updated: December 2025')</p>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/popup.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/platform-setting.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/popup.js') }}"></script>
    <script src="{{ asset('assets/admin/js/platform-setting.js') }}"></script>
@endpush
