@extends('admin.layouts.app')

@section('panel')
    <div class="doc-container">
        <div class="row gy-4">
            <div class="col-xl-3">
                <div class="doc-sidebar">
                    <h5>@lang('Table of Contents')</h5>
                    <nav class="nav flex-column">
                        <a class="nav-link active" href="#overview">@lang('Overview')</a>
                        <a class="nav-link" href="#prerequisites">@lang('Prerequisites')</a>
                        <a class="nav-link" href="#create-account">@lang('Create Developer Account')</a>
                        <a class="nav-link" href="#create-app">@lang('Create Twitter App')</a>
                        <a class="nav-link" href="#configure-oauth">@lang('Configure OAuth Settings')</a>
                        <a class="nav-link" href="#get-credentials">@lang('Get API Credentials')</a>
                        <a class="nav-link" href="#troubleshooting">@lang('Troubleshooting')</a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-xl-9">
                <div class="doc-content">
                    <section id="overview" class="doc-section">
                        <h2>@lang('Overview')</h2>
                        <p>@lang('This documentation will guide you through the process of creating and configuring a Twitter Developer Account and App to integrate Twitter features into your application. You\'ll learn how to create a developer account, set up an app, configure OAuth 2.0 settings, and generate the necessary API credentials.')</p>

                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Important:')</strong> @lang('Twitter API integration requires a Developer Account and an approved app with OAuth 2.0 credentials. Your application must comply with Twitter\'s Developer Agreement and Policy.')
                        </div>
                    </section>

                    <section id="prerequisites" class="doc-section">
                        <h2>@lang('Prerequisites')</h2>

                        <p>
                            @lang('Before creating and configuring a Twitter API integration, ensure the following requirements are met. These are mandatory to avoid project creation issues, permission rejections, or verification failures.')
                        </p>

                        <div class="requirements-list">
                            <ul>
                                <li>
                                    <strong>@lang('Twitter Account')</strong><br>
                                    @lang('A valid Twitter account with a confirmed email address and phone number.')
                                </li>

                                <li>
                                    <strong>@lang('Verified Email Address')</strong><br>
                                    @lang('Your Twitter account must have a verified email address.')
                                </li>

                                <li>
                                    <strong>@lang('Verified Phone Number')</strong><br>
                                    @lang('Your Twitter account must have a verified phone number.')
                                </li>

                                <li>
                                    <strong>@lang('Verified Website Domain')</strong><br>
                                    @lang('A valid website with a publicly accessible domain for OAuth redirect URIs.')
                                </li>

                                <li>
                                    <strong>@lang('Privacy Policy URL (Required)')</strong><br>
                                    @lang('A publicly accessible privacy policy page explaining how user data is collected, used, and stored.')
                                </li>

                                <li>
                                    <strong>@lang('Terms of Service URL (Recommended)')</strong><br>
                                    @lang('A clear Terms of Service page describing user responsibilities and platform usage.')
                                </li>

                                <li>
                                    <strong>@lang('Application Use-Case Description')</strong><br>
                                    @lang('A clear explanation of how the application uses Twitter data and API access.')
                                </li>

                                <li>
                                    <strong>@lang('Secure Website (HTTPS)')</strong><br>
                                    @lang('The application website must use HTTPS. HTTP URLs are not accepted for OAuth redirect URIs.')
                                </li>
                            </ul>
                        </div>
                    </section>

                    <section id="create-account" class="doc-section">
                        <h2>@lang('Step 1: Create Twitter Developer Account')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Navigate to Twitter Developer Portal')</div>
                                    <p>
                                        @lang('Go to')
                                        <a href="https://developer.twitter.com" target="_blank">https://developer.twitter.com</a>
                                        @lang('and sign in with your Twitter account.')
                                    </p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/twitter/01.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/01.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Enter In Developer Portal')</div>
                                    <p>
                                        @lang('Click') <strong>@lang('Click "Developer Portal"')</strong> @lang('to access the Developer Portal dashboard.')
                                    </p>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/twitter/02.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/02.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/twitter/03.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/03.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <section id="create-app" class="doc-section">
                        <h2>@lang('Step 2: Create a Twitter App')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Access Developer Portal Dashboard')</div>
                                    <p>@lang('Once your developer account is approved, navigate to the') <strong>@lang('Developer Dashboard')</strong> @lang('and click') <strong>@lang('"Create Project"')</strong>.</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/twitter/04.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/04.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Create New App')</div>
                                    <p>@lang('Enter your') <strong>@lang('App name')</strong> @lang('and click') <strong>@lang('"Next"')</strong> @lang('to proceed to the app creation form.')</p>
                                    <p>@lang('Enter App "Use case" and click') <strong>@lang('"Next"')</strong>.</p>
                                    <p>@lang('Give APP description and click') <strong>@lang('"Next"')</strong>.</p>
                                    <p>@lang('Complete all steps and click') <strong>@lang('"Create"')</strong>.</p>

                                    <div class="d-flex justify-content-center gap-3 flex-wrap">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/twitter/05.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/05.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/twitter/06.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/06.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/twitter/07.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/07.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/twitter/08.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/08.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Note:')</strong> @lang('Save your API keys and tokens immediately after app creation as they may not be shown again.')
                        </div>
                    </section>

                    <section id="configure-oauth" class="doc-section">
                        <h2>@lang('Step 3: Configure OAuth 2.0 Settings')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Access App Settings')</div>
                                    <p>@lang('Click on your app name to access its settings, then navigate to the') <strong>@lang('Settings')</strong> @lang('tab. Click the "Edit" button.')</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/twitter/09.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/09.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Set Up User Authentication')</div>

                                    <p>@lang('Scroll down to') <strong>@lang('User authentication settings')</strong> @lang('and click') <strong>@lang('"Set up"')</strong> @lang('or') <strong>@lang('"Edit"')</strong>.</p>

                                    <ul class="app-details-list">
                                        <li>
                                            <strong>@lang('App permissions:')</strong>
                                            @lang('Select "Read and write" or "Read" based on your needs.')
                                        </li>

                                        <li>
                                            <strong>@lang('Type of App:')</strong>
                                            @lang('Select "Web App, Automated App or Bot".')
                                        </li>

                                        <li>
                                            <strong>@lang('App Info:')</strong>
                                            @lang('Provide Callback URI, Website URL, Terms of Service, and Privacy Policy URLs.')
                                        </li>
                                    </ul>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/twitter/09.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/09.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/twitter/10.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/10.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Add Callback URL')</div>

                                    <p>@lang('In the') <strong>@lang('Callback URI / Redirect URL')</strong> @lang('field, add:')</p>
                                    <div class="mb-3">
                                        <p>@lang('The callback URL should be:')</p>
                                        <div class="callback-link">
                                            <code>{{ route('user.social.connect.callback', 'twitter') }}</code>
                                            <button class="copy-btn">
                                                <i class="las la-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <p>@lang('Click') <strong>@lang('"Save"')</strong> @lang('to apply the changes.').</p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/twitter/11.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/11.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-success-custom">
                            <strong>
                                <i class="fas fa-check-circle me-2"></i>@lang('Success!')
                            </strong>
                            @lang('OAuth 2.0 settings have been configured successfully.')
                        </div>

                    </section>

                    <section id="get-credentials" class="doc-section">
                        <h2>@lang('Step 4: Get API Credentials')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Access Keys and Tokens')</div>
                                    <p>
                                        @lang('Navigate to the') <strong>@lang('Keys and tokens')</strong> @lang('tab in your app settings.')
                                    </p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/twitter/12.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/12.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Copy Client Secret key')</div>

                                    <p>@lang('Locate your') <strong>@lang('Client Secret key')</strong>. @lang('Click') <strong>@lang('"Regenerate"')</strong> @lang('if needed, then copy both values.').</p>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/twitter/14.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/14.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/twitter/13.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/13.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Get Client ID ')</div>
                                    <p>@lang('Locate your') <strong>@lang('Client ID')</strong>. @lang('Copy the value for use in your application.').</p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/twitter/15.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/15.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">4</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Setup Credentials in Your Web Application')</div>
                                    <p>@lang('Add the API Key, API Secret, Client ID, and Client Secret in your web application settings.').</p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/twitter/16.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/twitter/16.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong> @lang('Keep your API credentials secure. Never share them publicly or commit them to version control. Store them as environment variables.')
                        </div>

                        <div class="alert-success-custom">
                            <strong>
                                <i class="fas fa-check-circle me-2"></i>@lang('Success!')
                            </strong>
                            @lang('Your Twitter API integration is now configured and ready to use.')
                        </div>

                    </section>

                    <section id="troubleshooting" class="doc-section">
                        <h2>@lang('Troubleshooting')</h2>

                        <h3>@lang('Common Issues and Solutions')</h3>

                        <div class="step-card">
                            <div class="step-title">@lang('Callback URL Mismatch Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Error: Invalid callback URL or redirect URI mismatch')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Ensure your callback URI in the application exactly matches the one configured in Twitter Developer Portal. Check for:'):</p>
                            <ul class="app-details-list">
                                <li>@lang('Trailing slashes')</li>
                                <li>@lang('HTTP vs HTTPS')</li>
                                <li>@lang('Correct domain spelling')</li>
                                <li>@lang('Query parameters')</li>
                            </ul>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Unauthorized Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('401 Unauthorized - Could not authenticate you')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Verify that you are using the correct API keys and tokens. Make sure your app has the necessary permissions enabled.')
                            </p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Rate Limit Exceeded')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Error 429: Too Many Requests')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('You have exceeded the rate limits for your access level. Solutions include:'):</p>
                            <ul class="app-details-list">
                                <li>@lang('Wait for the rate limit window to reset')</li>
                                <li>@lang('Implement request throttling in your application')</li>
                                <li>@lang('Consider upgrading to a higher API access tier')</li>
                            </ul>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Forbidden Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Error 403: Forbidden - Your app does not have the required permissions')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Check your app permissions in the Developer Portal. Ensure you have requested and been granted the necessary access levels for the API endpoints you are trying to use.')
                            </p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Developer Account Suspended')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Your developer account or app has been suspended')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Review Twitter\'s Developer Policy to ensure compliance. Contact Twitter Developer Support to appeal the suspension if you believe it was made in error.')
                            </p>
                        </div>

                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong> @lang('Always comply with Twitter\'s Developer Agreement and Policy. Violations can result in app suspension or permanent ban from the platform.')
                        </div>

                        <h3>@lang('Useful Resources')</h3>
                        <div class="requirements-list">
                            <ul>
                                <li><a href="https://developer.twitter.com/en/docs" target="_blank">@lang('Twitter API Documentation')</a></li>
                                <li><a href="https://developer.twitter.com/en/portal/dashboard" target="_blank">@lang('Twitter Developer Portal')</a></li>
                                <li><a href="https://developer.twitter.com/en/docs/authentication/oauth-2-0" target="_blank">@lang('OAuth 2.0 Authorization')</a></li>
                                <li><a href="https://developer.twitter.com/en/docs/twitter-api/rate-limits" target="_blank">@lang('Rate Limits and Quotas')</a></li>
                                <li><a href="https://developer.twitter.com/en/developer-terms" target="_blank">@lang('Developer Agreement and Policy')</a></li>
                                <li><a href="https://developer.twitter.com/en/support" target="_blank">@lang('Developer Support')</a></li>
                            </ul>
                        </div>
                    </section>

                    <div class="text-center mt-5 pt-4 border-top">
                        <p class="text-muted">@lang('Last Updated: December 2025')</p>
                    </div>

                </div>
            </div>
        </div>

    </div>
@endsection
@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/popup.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/platform-setting.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/popup.js') }}"></script>
    <script src="{{ asset('assets/admin/js/platform-setting.js') }}"></script>
@endpush
