@extends('admin.layouts.app')

@section('panel')
    <div class="doc-container">
        <div class="row gy-4">
            <div class="col-xl-3">
                <div class="doc-sidebar">
                    <h5>@lang('Table of Contents')</h5>
                    <nav class="nav flex-column">
                        <a class="nav-link active" href="#overview">@lang('Overview')</a>
                        <a class="nav-link" href="#prerequisites">@lang('Prerequisites')</a>
                        <a class="nav-link" href="#create-account">@lang('Create Developer Account')</a>
                        <a class="nav-link" href="#create-app">@lang('Create TikTok App')</a>
                        <a class="nav-link" href="#complete-setup">@lang('Complete Setup')</a>
                        <a class="nav-link" href="#configure-scopes">@lang('Configure Scopes')</a>
                        <a class="nav-link" href="#get-credentials">@lang('Get API Credentials')</a>
                        <a class="nav-link" href="#troubleshooting">@lang('Troubleshooting')</a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-xl-9">
                <div class="doc-content">
                    <section id="overview" class="doc-section">
                        <h2>@lang('Overview')</h2>
                        <p>@lang('This documentation will guide you through the process of creating and configuring a TikTok Developer Account and App to integrate TikTok features into your application. You\'ll learn how to create a developer account, set up an app, configure TikTok Login Kit, and generate the necessary API credentials.')</p>

                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Important:')</strong> @lang('TikTok API integration requires a Developer Account and an approved app with proper permissions. Your application must comply with TikTok\'s Developer Terms of Service and API Terms.')
                        </div>
                    </section>

                    <section id="prerequisites" class="doc-section">
                        <h2>@lang('Prerequisites')</h2>

                        <p>@lang('Before creating and configuring a TikTok API integration, ensure the following requirements are met. These are mandatory to avoid project creation issues, permission rejections, or verification failures.')</p>

                        <div class="requirements-list">
                            <ul>
                                <li><strong>@lang('TikTok Account')</strong><br>@lang('A valid TikTok account with a confirmed email address.')</li>
                                <li><strong>@lang('Business Account (Recommended)')</strong><br>@lang('A TikTok Business account for better API access and features.')</li>
                                <li><strong>@lang('Verified Email Address')</strong><br>@lang('Your TikTok account must have a verified email address.')</li>
                                <li><strong>@lang('Verified Website Domain')</strong><br>@lang('A valid website with a publicly accessible domain for OAuth redirect URIs.')</li>
                                <li><strong>@lang('Privacy Policy URL (Required)')</strong><br>@lang('A publicly accessible privacy policy page explaining how user data is collected, used, and stored.')</li>
                                <li><strong>@lang('Terms of Service URL (Required)')</strong><br>@lang('A clear Terms of Service page describing user responsibilities and platform usage.')</li>
                                <li><strong>@lang('Application Use-Case Description')</strong><br>@lang('A clear explanation of how the application uses TikTok data and API access.')</li>
                                <li><strong>@lang('Secure Website (HTTPS)')</strong><br>@lang('The application website must use HTTPS. HTTP URLs are not accepted for OAuth redirect URIs.')</li>
                                <li><strong>@lang('Valid Business Information')</strong><br>@lang('Company name, contact information, and other business details may be required for verification.')</li>
                            </ul>
                        </div>
                    </section>

                    <section id="create-account" class="doc-section">
                        <h2>@lang('Step 1: Create TikTok Developer Account')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Navigate to TikTok for Developers')</div>
                                    <p>@lang('Go to') <a href="https://developers.tiktok.com" target="_blank">https://developers.tiktok.com</a> @lang('and click') <strong>@lang('"Register"')</strong> @lang('or') <strong>@lang('"Sign up"')</strong> @lang('button.')</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/tiktok/01.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/01.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Sign In with TikTok Account')</div>
                                    <p>@lang('After signing up, you will be to reach the') <strong>@lang('"Developer Portal".')</strong></p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/tiktok/02.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/02.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-success-custom">
                            <strong><i class="fas fa-check-circle me-2"></i>@lang('Success!')</strong>
                            @lang('Your TikTok Developer Account has been created. You can now proceed to create your first app.')
                        </div>
                    </section>

                    <section id="create-app" class="doc-section">
                        <h2>@lang('Step 2: Create a TikTok App')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Access Developer Portal')</div>
                                    <p>@lang('Once logged in, navigate to the') <strong>@lang('Developer Portal')</strong> @lang('and go to') <strong>@lang('Manage apps')</strong>.</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/tiktok/03.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/03.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Create New App')</div>
                                    <p>@lang('Click the') <strong>@lang('"Connect an app"')</strong> @lang('or') <strong>@lang('"Create new app"')</strong> @lang('button.').</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/tiktok/04.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/04.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Fill App Information')</div>
                                    <p>@lang('Complete the app creation form with the following details:')</p>
                                    <ul class="app-details-list">
                                        <li><strong>@lang('Ownership:')</strong> @lang('Select the owner type (Individual).')</li>
                                        <li><strong>@lang('App Name:')</strong> @lang('Enter a name for your app.')</li>
                                        <li><strong>@lang('App Type:')</strong> @lang('Select the type of app (Other).')</li>
                                        <li><strong>@lang('Create:')</strong> @lang('Click "Create" to finalize app creation.')</li>
                                    </ul>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/05.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/05.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/06.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/06.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Note:')</strong> @lang('After creating your app, use Production for "production" access, and for the test purpose you can use User "Sandbox". However, the "Production" access requires TikTok review and approval based on the permissions you request.')
                        </div>
                    </section>


                    <section id="complete-setup" class="doc-section">
                        <h2>@lang('Step 3: Configure Tiktok App')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Give Required Information')</div>
                                    <p>@lang('Provide your App Icon, Category, and Description. You have to provide a valid Terms of Service and Privacy Policy URLs.')</p>
                                    <p>@lang('Select "Web" as Platforms and setup your site Url.')</p>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/07.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/07.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/08.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/08.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Configure Login Kit Settings')</div>
                                    <p>@lang('Set up the Login Kit with the following information:')</p>
                                    <ul class="app-details-list">
                                        <li><strong>@lang('Redirect URI:')</strong> @lang('Add your application\'s callback URL.')</li>
                                        <li><strong>@lang('Scopes:')</strong> @lang('Select the permissions your app needs (user.info.basic, video.list, etc.).')</li>
                                        <li><strong>@lang('Login Settings:')</strong> @lang('Configure additional login settings as required.')</li>
                                    </ul>
                                    <div>
                                        <p>@lang('The callback URL should be:')</p>
                                        <div class="callback-link">
                                            <code>{{ route('user.social.connect.callback', 'tiktok') }}</code>
                                            <button class="copy-btn">
                                                <i class="las la-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/10.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/10.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Verify Domain')</div>
                                    <p>@lang('In the') <strong>@lang('Content Posting API')</strong> @lang('section, turn on "Direct Post" option and click the verify button')</p>
                                    <p>@lang('Click') <strong>@lang('"Save"')</strong> @lang('to apply the changes.').</p>
                                    <p>@lang('Select "URL prefix option and give your site URL"')</p>
                                    <p>@lang('Download the .txt file and upload to your server root folder then click the verify button')</p>
                                    <div class="d-flex justify-content-center flex-wrap gap-3">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/11.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/11.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/12.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/12.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/13.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/13.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/14.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/14.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/15.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/15.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-success-custom">
                            <strong><i class="fas fa-check-circle me-2"></i>@lang('Success!')</strong>
                            @lang('TikTok Login Kit and Verification has been configured successfully.')
                        </div>
                    </section>


                    <section id="configure-scopes" class="doc-section">
                        <h2>@lang('Step 3: Configure Scopes')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Review OAuth Scopes')</div>
                                    <p>@lang('In the Auth tab, scroll down to') <strong>@lang('OAuth 2.0 scopes')</strong> @lang('section.')</p>
                                    <p>@lang('Select the following scopes:')</p>

                                    <div class="mt-3">
                                        <span class="permission-badge">user.info.basic</span>
                                        <span class="permission-badge">user.info.profile</span>
                                        <span class="permission-badge">user.info.stats</span>
                                        <span class="permission-badge">video.list</span>
                                        <span class="permission-badge">video.upload</span>
                                        <span class="permission-badge">video.publish</span>
                                    </div>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/16.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/16.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/17.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/17.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="alert-success-custom">
                            <strong><i class="fas fa-check-circle me-2"></i>@lang('Success!')</strong>
                            @lang('TikTok Login Kit has been configured successfully.')
                        </div>
                    </section>

                    <section id="get-credentials" class="doc-section">
                        <h2>@lang('Step 4: Get API Credentials')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Access App Credentials')</div>
                                    <p>@lang('From your App Details copy the') <strong>@lang('Client Key')</strong> @lang('and') <strong>@lang('Client Secret')</strong>.</p>
                                    <p>@lang('Setup the credentials in your web application settings.')</p>
                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/18.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/18.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>

                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/tiktok/19.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/tiktok/19.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-success-custom">
                            <strong><i class="fas fa-check-circle me-2"></i>@lang('Success!')</strong>
                            @lang('Your TikTok API integration is now configured and ready to use.')
                        </div>
                    </section>

                    <section id="troubleshooting" class="doc-section">
                        <h2>@lang('Troubleshooting')</h2>
                        <h3>@lang('Common Issues and Solutions')</h3>

                        <div class="step-card">
                            <div class="step-title">@lang('Redirect URI Mismatch Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Error: redirect_uri parameter does not match a registered value')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Ensure your redirect URI in the application exactly matches the one configured in TikTok Developer Portal. Check for:'):</p>
                            <ul class="app-details-list">
                                <li>@lang('Trailing slashes')</li>
                                <li>@lang('HTTP vs HTTPS')</li>
                                <li>@lang('Correct domain spelling')</li>
                                <li>@lang('Port numbers if applicable')</li>
                            </ul>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Invalid Client Key or Secret')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Authentication failed with invalid_client error')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Verify that you are using the correct Client Key and Client Secret. Make sure there are no extra spaces or characters when copying credentials.')</p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Permission Denied Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Error: insufficient permissions or scope not granted')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Check that you have added and enabled the required scopes in your Login Kit configuration. Some scopes may require app review and approval.')</p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Rate Limit Exceeded')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Error: Too many requests or rate limit exceeded')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('You have exceeded the API rate limits. Solutions include:'):</p>
                            <ul class="app-details-list">
                                <li>@lang('Wait for the rate limit window to reset')</li>
                                <li>@lang('Implement request throttling in your application')</li>
                                <li>@lang('Cache API responses when appropriate')</li>
                                <li>@lang('Review TikTok\'s rate limit documentation for your tier')</li>
                            </ul>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('App Not Approved Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Your app is in pending review or not approved status')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Some API features require app review and approval. Check your app status in the Developer Portal. If your review was rejected, read the feedback carefully and make necessary changes before resubmitting.')</p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Token Expired Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Access token has expired')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Implement token refresh logic in your application. Use the refresh token to obtain a new access token before it expires. TikTok access tokens typically have a limited lifetime.')</p>
                        </div>

                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong> @lang('Always comply with TikTok\'s Developer Terms and API Terms. Violations can result in app suspension or permanent ban from the platform.')
                        </div>

                        <h3>@lang('Useful Resources')</h3>
                        <div class="requirements-list">
                            <ul>
                                <li><a href="https://developers.tiktok.com/doc" target="_blank">@lang('TikTok API Documentation')</a></li>
                                <li><a href="https://developers.tiktok.com" target="_blank">@lang('TikTok Developer Portal')</a></li>
                                <li><a href="https://developers.tiktok.com/doc/login-kit-web" target="_blank">@lang('Login Kit Documentation')</a></li>
                                <li><a href="https://developers.tiktok.com/doc/rate-limits" target="_blank">@lang('API Rate Limits')</a></li>
                                <li><a href="https://developers.tiktok.com/terms" target="_blank">@lang('Developer Terms of Service')</a></li>
                                <li><a href="https://developers.tiktok.com/support" target="_blank">@lang('Developer Support')</a></li>
                            </ul>
                        </div>
                    </section>

                    <div class="text-center mt-5 pt-4 border-top">
                        <p class="text-muted">@lang('Last Updated: December 2025')</p>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/popup.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/platform-setting.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/popup.js') }}"></script>
    <script src="{{ asset('assets/admin/js/platform-setting.js') }}"></script>
@endpush
