@extends('admin.layouts.app')

@section('panel')
    <div class="doc-container">
        <div class="row gy-4">
            <div class="col-xl-3">
                <div class="doc-sidebar">
                    <h5>@lang('Table of Contents')</h5>
                    <nav class="nav flex-column">
                        <a class="nav-link active" href="#overview">@lang('Overview')</a>
                        <a class="nav-link" href="#setup">@lang('Setup Callback URL')</a>
                        <a class="nav-link" href="#permissions">@lang('Setup Permissions')</a>
                        <a class="nav-link" href="#important-notes">@lang('Important Notes')</a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-xl-9">
                <div class="doc-content">
                    <!-- Overview Section -->
                    <section id="overview" class="doc-section">
                        <h2>@lang('Overview')</h2>
                        <p>@lang('This documentation will guide you through configuring Instagram integration with your application. Instagram uses the same Meta App infrastructure as Facebook, so you\'ll need to configure the callback URL in your existing Meta App.')</p>

                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Note:')</strong> @lang('Instagram integration uses your existing Meta App. If you haven\'t created a Meta App yet, please refer to the Facebook documentation first.')
                        </div>
                    </section>

                    <!-- Setup Section -->
                    <section id="setup" class="doc-section">
                        <h2>@lang('Setup Callback URL')</h2>
                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Configure Instagram Callback URL')</div>
                                    <p>
                                        @lang('Navigate to your Meta App dashboard at')
                                        <a href="https://developers.facebook.com" target="_blank">https://developers.facebook.com</a>
                                    </p>

                                    <p>@lang('Follow these steps:')</p>
                                    <ul class="app-details-list">
                                        <li>@lang('Go to') <strong>@lang('Products')</strong> @lang('in the left sidebar')</li>
                                        <li>@lang('Find') <strong>@lang('Facebook')</strong> @lang('and click') <strong>@lang('Settings')</strong></li>
                                        <li>@lang('Locate the') <strong>@lang('Valid OAuth Redirect URIs')</strong> @lang('field')</li>
                                        <li>@lang('Copy the callback URL from your web application Platform Settings and paste it:')</li>
                                    </ul>

                                    <div class="mb-3 w-100">
                                        <p>@lang('The callback URL should be:')</p>
                                        <div class="callback-link">
                                            <code>{{ route('user.social.connect.callback', 'instagram') }}</code>
                                            <button class="copy-btn">
                                                <i class="las la-copy"></i>
                                            </button>
                                        </div>
                                    </div>

                                    <p>@lang('After adding the URL, click') <strong>@lang('Save Changes')</strong> @lang('to apply the configuration.')</p>

                                    <div class="screenshot-wrapper mt-4">
                                        <a href="{{ asset('assets/admin/images/documentation/instagram/01.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/instagram/01.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Instagram Settings Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-success-custom mt-4">
                            <strong>
                                <i class="fas fa-check-circle me-2"></i>@lang('Success!')
                            </strong>
                            @lang('Your Instagram callback URL has been configured successfully.')
                        </div>
                    </section>

                    <section id="permissions" class="doc-section">
                        <h2>@lang('Step 3: Configure Permissions')</h2>

                        <h3>@lang('Required Permissions')</h3>
                        <p>@lang('The following permissions are available for your app:') </p>

                        <div class="row mt-4">
                            <div class="col-md-12">
                                <h4>@lang('Advanced Permissions') (@lang('Review Required'))</h4>
                                <div class="mt-3">
                                    <span class="permission-badge">instagram_basic</span>
                                    <span class="permission-badge">pages_show_list</span>
                                    <span class="permission-badge">business_management</span>
                                    <span class="permission-badge">instagram_manage_messages</span>
                                    <span class="permission-badge">pages_read_engagement</span>
                                </div>
                            </div>

                            <div class="step-card mt-3">
                                <div class="d-flex align-items-start step-card__wrapper">
                                    <div class="step-content">
                                        <span class="step-number">1</span>
                                        <div>
                                            <div class="step-title">@lang('Apply For Permissions')</div>
                                            <p>
                                                @lang('To request advanced permissions, navigate to App Review > Permissions and Features in your app dashboard. Select the required permissions and provide detailed explanations and screencast demonstrations of how your app will use each permission. Submit the application for review.')
                                            </p>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/facebook/14.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/14.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <!-- Important Notes Section -->
                        <section id="important-notes" class="doc-section">
                            <h2>@lang('Important Notes')</h2>

                            <div class="alert-warning-custom">
                                <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Account Connection Limitation:')</strong>
                                <p class="mb-0">
                                    @lang('Only Instagram accounts that are created or managed by the same Facebook account used to create the Meta App can be connected to the web application. This is a Meta platform restriction.')
                                </p>
                            </div>

                            <div class="step-card mt-4">
                                <div class="step-title">@lang('What This Means')</div>
                                <ul class="app-details-list">
                                    <li>@lang('The Facebook account that created the Meta App must also manage the Instagram account')</li>
                                    <li>@lang('Instagram Business or Creator accounts must be linked to the same Facebook Page')</li>
                                    <li>@lang('Personal Instagram accounts cannot be connected unless they are converted to Business/Creator accounts and linked to your Facebook Page')</li>
                                    <li>@lang('Other users\' Instagram accounts cannot connect to your application without proper Meta App Review approval for advanced permissions')</li>
                                </ul>
                            </div>

                            <div class="alert-info-custom mt-4">
                                <strong><i class="fas fa-info-circle me-2"></i>@lang('Need More Access?')</strong>
                                <p class="mb-0">
                                    @lang('If you need to allow other users to connect their Instagram accounts, you must complete the Meta App Review process and obtain the necessary permissions. Refer to the Facebook documentation for details on the app review process.')
                                </p>
                            </div>

                            <h3 class="mt-5">@lang('Useful Resources')</h3>
                            <div class="requirements-list">
                                <ul>
                                    <li><a href="https://developers.facebook.com/docs/instagram" target="_blank">@lang('Instagram Platform Documentation')</a></li>
                                    <li><a href="https://developers.facebook.com/docs/instagram-basic-display-api" target="_blank">@lang('Instagram Basic Display API')</a></li>
                                    <li><a href="https://developers.facebook.com/docs/instagram-api" target="_blank">@lang('Instagram Graph API')</a></li>
                                    <li><a href="https://developers.facebook.com/docs/app-review" target="_blank">@lang('App Review Guidelines')</a></li>
                                </ul>
                            </div>
                        </section>

                        <div class="text-center mt-5 pt-4 border-top">
                            <p class="text-muted">@lang('Last Updated: December 2025')</p>
                        </div>

                </div>
            </div>
        </div>

    </div>
@endsection

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/popup.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/platform-setting.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/popup.js') }}"></script>
    <script src="{{ asset('assets/admin/js/platform-setting.js') }}"></script>
@endpush
