@extends('admin.layouts.app')

@section('panel')
    <div class="doc-container">
        <div class="row gy-4">
            <div class="col-xl-3">
                <div class="doc-sidebar">
                    <h5>@lang('Table of Contents')</h5>
                    <nav class="nav flex-column">
                        <a class="nav-link active" href="#overview">@lang('Overview')</a>
                        <a class="nav-link" href="#prerequisites">@lang('Prerequisites')</a>
                        <a class="nav-link" href="#create-app">@lang('Create Meta App')</a>
                        <a class="nav-link" href="#configure-app">@lang('Configure App')</a>
                        <a class="nav-link" href="#permissions">@lang('Set Permissions')</a>
                        <a class="nav-link" href="#troubleshooting">@lang('Troubleshooting')</a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-xl-9">
                <div class="doc-content">
                    <section id="overview" class="doc-section">
                        <h2>@lang('Overview')</h2>
                        <p>@lang('This documentation will guide you through the process of creating and configuring a Facebook Meta App to integrate social media features into your application. You\'ll learn how to obtain the necessary permissions, generate access tokens, and properly configure your app for production use.')</p>

                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Important:')</strong> @lang('Facebook Meta apps require approval for advanced permissions. Basic permissions are available immediately, but features like posting or accessing user data require app review.')
                        </div>
                    </section>

                    <section id="prerequisites" class="doc-section">
                        <h2>@lang('Prerequisites')</h2>

                        <p>
                            @lang('Before creating and configuring a Meta App, ensure the following requirements are met. These are mandatory to avoid app creation issues, permission rejections, or app review failures.')
                        </p>

                        <div class="requirements-list">
                            <ul>
                                <li>
                                    <strong>@lang('Active Facebook Account')</strong><br>
                                    @lang('A valid Facebook account with a confirmed email address.')
                                </li>

                                <li>
                                    <strong>@lang('Facebook Page')</strong><br>
                                    @lang('At least one Facebook Page owned or managed by the account. Page-related permissions will not work without this.')
                                </li>

                                <li>
                                    <strong>@lang('Verified Website Domain')</strong><br>
                                    @lang('A valid website with a publicly accessible domain. The domain must be added and verified in Meta Business Manager.')
                                </li>

                                <li>
                                    <strong>@lang('Privacy Policy URL (Required)')</strong><br>
                                    @lang('A publicly accessible privacy policy page explaining how user data is collected, used, and stored.')
                                </li>

                                <li>
                                    <strong>@lang('Terms of Service URL (Required for App Review)')</strong><br>
                                    @lang('A clear Terms of Service page describing user responsibilities and platform usage.')
                                </li>

                                <li>
                                    <strong>@lang('App Use-Case Description')</strong><br>
                                    @lang('A clear explanation of how the app uses Facebook data and permissions. This is required during app review.')
                                </li>

                                <li>
                                    <strong>@lang('Secure Website (HTTPS)')</strong><br>
                                    @lang('The application website must use HTTPS. HTTP URLs are rejected during app review.')
                                </li>
                            </ul>
                        </div>
                    </section>

                    <section id="create-app" class="doc-section">
                        <h2>@lang('Step 1: Create a Meta App')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Navigate to Meta Developers')</div>
                                    <p>
                                        @lang('Go to')
                                        <a href="https://developers.facebook.com" target="_blank">https://developers.facebook.com</a>
                                        @lang('and click on') <strong>@lang('"My Apps"')</strong> @lang('in the top right corner.')
                                    </p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/facebook/01.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/01.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Create New App')</div>
                                    <p>
                                        @lang('Click the') <strong>@lang('"Create App"')</strong> @lang('button. You\'ll be presented with different app types. Select the type that best matches your use case:')
                                    </p>

                                    <div class="alert-info-custom">
                                        <strong><i class="fas fa-info-circle me-2"></i>@lang('Important:')</strong> @lang('When creating a Meta App for the first time, you must register and verify your account with a valid phone number. During the setup, you will be prompted to select an app type. To access all the required permissions for integration, choose the') <strong>@lang('Business')</strong> @lang('app type.')
                                    </div>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/facebook/02.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/02.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Fill in App Details')</div>

                                    <p>
                                        @lang('Provide the required information to complete the app creation process. Follow the steps below carefully:')
                                    </p>

                                    <ul class="app-details-list">
                                        <li>
                                            <strong>@lang('App Name:')</strong>
                                            @lang('Enter a unique and descriptive name for your application.')
                                        </li>

                                        <li>
                                            <strong>@lang('App Contact Email:')</strong>
                                            @lang('Provide a valid email address for official communication, then click Next.')
                                        </li>

                                        <li>
                                            <strong>@lang('Use Cases:')</strong>
                                            @lang('Select All->Others from the dropdown and click Next.')
                                        </li>

                                        <li>
                                            <strong>@lang('Business:')</strong>
                                            @lang('Choose the app type as Business and click Next.')
                                        </li>
                                        <li>
                                            <strong>@lang('Verification:')</strong>
                                            @lang('Complete the security check if prompted.')
                                        </li>
                                    </ul>
                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper d-flex justify-content-center">
                                            <a href="{{ asset('assets/admin/images/documentation/facebook/03.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/03.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper d-flex justify-content-center">
                                            <a href="{{ asset('assets/admin/images/documentation/facebook/04.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/04.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper d-flex justify-content-center">
                                            <a href="{{ asset('assets/admin/images/documentation/facebook/05.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/05.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper d-flex justify-content-center">
                                            <a href="{{ asset('assets/admin/images/documentation/facebook/06.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/06.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="alert-success-custom">
                            <strong>
                                <i class="fas fa-check-circle me-2"></i>@lang('Success!')
                            </strong>
                            @lang("Your app has been created. You'll now see your App ID and App Secret in the dashboard.")

                        </div>
                    </section>

                    <!-- Configure App Section -->
                    <section id="configure-app" class="doc-section">
                        <h2>@lang('Step 2: Configure App Settings')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Access Basic Settings')</div>
                                    <p>@lang('From your app dashboard, navigate to ')<strong>@lang('App Settings > Basic')</strong>. @lang('Here you\'ll configure essential app information. Setup your app\'s name, icon, app domain, private policy, terms of service and description. Click save changes')</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/facebook/07.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/07.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Add Platform')</div>
                                    <p>@lang('Go to Dashboard') @lang('Scroll to the bottom and add') <strong>@lang('Facebook Login for Business')</strong>.</p>
                                    <p>@lang('Click') <strong>@lang('Live')</strong> @lang('to publish your app').</p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/facebook/08.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/08.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Setup Callback url')</div>
                                    <p>
                                        @lang('Copy the Facebook callback URL from the Platform Settings section and paste it into the "Valid OAuth Redirect URIs" field under Facebook Login settings. After adding the URL, click "Save Changes" to apply the configuration.')
                                    </p>
                                    
                                    <div>
                                        <p>@lang('The callback URL should be:')</p>
                                        <div class="callback-link">
                                            <code>{{ route('user.social.connect.callback', 'facebook') }}</code>
                                            <button class="copy-btn">
                                                <i class="las la-copy"></i>
                                            </button>
                                        </div>
                                    </div>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/facebook/11.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/11.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/facebook/10.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/10.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">4</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Setup Credentials')</div>
                                    <p>
                                        @lang('Navigate to Settings > Basic to find your App ID and App Secret. Click "Show" to reveal the App Secret. Copy both values as they will be needed for integration with your application.')
                                    </p>
                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/facebook/12.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/12.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/facebook/13.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/13.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong>@lang('Save your App ID and App Secret. You\'ll need these credentials for integration. Never share your App Secret publicly.')
                        </div>
                    </section>

                    <!-- Permissions Section -->
                    <section id="permissions" class="doc-section">
                        <h2>@lang('Step 3: Configure Permissions')</h2>

                        <h3>@lang('Required Permissions')</h3>
                        <p>@lang('The following permissions are available for your app:') </p>

                        <div class="row mt-4">
                            <div class="col-md-6">
                                <h4>@lang('Basic Permissions') (@lang('No Review Required'))</h4>
                                <div class="mt-3">
                                    <span class="permission-badge">email</span>
                                    <span class="permission-badge">public_profile</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h4>@lang('Advanced Permissions') (@lang('Review Required'))</h4>
                                <div class="mt-3">
                                    <span class="permission-badge">pages_manage_posts</span>
                                    <span class="permission-badge">pages_read_engagement</span>
                                    <span class="permission-badge">pages_show_list</span>
                                    <span class="permission-badge">pages_manage_metadata</span>
                                    <span class="permission-badge">business_management</span>
                                    <span class="permission-badge">pages_manage_engagement</span>
                                    <span class="permission-badge">pages_read_user_content</span>
                                    <span class="permission-badge">public_profile</span>
                                </div>
                            </div>

                            <div class="step-card mt-3">
                                <div class="d-flex align-items-start step-card__wrapper">
                                    <span class="step-number">1</span>
                                    <div class="step-content">
                                        <div class="step-title">@lang('Apply For Permissions')</div>
                                        <p>
                                            @lang('To request advanced permissions, navigate to App Review > Permissions and Features in your app dashboard. Select the required permissions and provide detailed explanations and screencast demonstrations of how your app will use each permission. Submit the application for review.')
                                        </p>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/facebook/14.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/facebook/14.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="alert-info-custom mt-4">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Note'):</strong>@lang('Advanced permissions require App Review. You\'ll need to provide detailed use cases and screencast demonstrations showing how your app uses these permissions.')
                        </div>
                    </section>

                    <!-- Troubleshooting Section -->
                    <section id="troubleshooting" class="doc-section">
                        <h2>@lang('Troubleshooting')</h2>

                        <h3>@lang('Common Issues and Solutions')</h3>

                        <div class="step-card">
                            <div class="step-title">@lang('OAuth Redirect URI Mismatch')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Can\'t Load URL: The domain of this URL isn\'t included in the app\'s domains')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Ensure your redirect URI is added in both'):</p>
                            <ul>
                                <li>@lang('Settings >') > @lang('Basic >') > @lang('App Domains')</li>
                                <li>@lang('Facebook Login') > @lang('Settings') > @lang('Valid OAuth Redirect URIs')</li>
                            </ul>
                        </div>

                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong>@lang('With out completing the app review process for advanced permissions, your user can\'t connect their Facebook page with the application. But you can connect your own Facebook account or page which is used to create the Meta App without app review.')
                        </div>

                        <h3>@lang('Useful Resources')</h3>
                        <div class="requirements-list">
                            <ul>
                                <li><a href="https://developers.facebook.com/docs" target="_blank">@lang('Official Facebook Developer Documentation')</a></li>
                                <li><a href="https://developers.facebook.com/tools/explorer" target="_blank">@lang('Graph API Explorer')</a></li>
                                <li><a href="https://developers.facebook.com/docs/app-review" target="_blank">@lang('App Review Guidelines')</a></li>
                                <li><a href="https://developers.facebook.com/support" target="_blank">@lang('Developer Support')</a></li>
                            </ul>
                        </div>
                    </section>

                    <div class="text-center mt-5 pt-4 border-top">
                        <p class="text-muted">@lang('Last Updated: December 2025')</p>
                    </div>

                </div>
            </div>
        </div>

    </div>
@endsection

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/popup.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/platform-setting.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/popup.js') }}"></script>
    <script src="{{ asset('assets/admin/js/platform-setting.js') }}"></script>
@endpush
