@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two custom-data-table">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Actions')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($platforms as $platform)
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb">
                                                    <img src="{{ getImage('assets/images/platform/' . $platform->image ?? '') }}" alt="{{ $platform->name }}" class="plugin_bg">
                                                </div>
                                                <span class="name">{{ __($platform->name) }}</span>
                                            </div>
                                        </td>

                                        <td>
                                            @if ($platform->status == Status::ENABLE)
                                                <span class="badge badge--success">@lang('Enabled')</span>
                                            @else
                                                <span class="badge badge--danger">@lang('Disabled')</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                @if (!$platform->status)
                                                    <button class="btn btn-outline--success confirmationBtn" data-action="{{ route('admin.platform.status', $platform->id) }}" data-question="@lang('Are you sure to enable this platform?')">
                                                        <i class="la la-eye"></i>@lang('Enable')
                                                    </button>
                                                @else
                                                    <button class="btn btn-outline--danger  confirmationBtn" data-action="{{ route('admin.platform.status', $platform->id) }}" data-question="@lang('Are you sure to disable this platform?')">
                                                        <i class="la la-eye-slash"></i>@lang('Disable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection
@push('breadcrumb-plugins')
    <a href="{{ route('admin.platform.setting') }}" class="btn btn-sm btn-outline--primary">
        <i class="la la-cog"></i> @lang('Setting')
    </a>
@endpush
