@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            @if (!gs('is_coupon'))
                @include('admin.partials.alert_box')
            @endif
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Code')</th>
                                    <th>@lang('Discount Type')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('MInimum Expend')</th>
                                    <th>@lang('Limit Per Coupon')</th>
                                    <th>@lang('Limit Per Customer')</th>
                                    <th>@lang('start Date')</th>
                                    <th>@lang('Expire Date')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody class="list">
                                @forelse($coupons as $coupon)
                                    <tr>
                                        <td>{{ $coupon->name ?? 'Unnamed' }}</td>
                                        <td> {{ $coupon->code }} </td>
                                        <td>
                                            @php echo $coupon->discountTypeBadge() @endphp
                                        </td>
                                        <td>
                                            {{ $coupon->discount_type == Status::DISCOUNT_FIXED ? showAmount($coupon->amount) : showAmount($coupon->amount,0,currencyFormat:false) }}
                                        </td>
                                        <td>
                                            {{ showAmount($coupon->minimum_spend) }}
                                        </td>
                                        <td>
                                            {{ $coupon->usage_limit_per_coupon }}
                                        </td>
                                        <td>
                                            {{ $coupon->usage_limit_per_customer }}
                                        </td>
                                        <td>
                                            {{ showDateTime($coupon->started_at, 'd M, Y h:i A') }}
                                        </td>
                                        <td class="{{ $coupon->expired_at < now() ? 'text--danger' : '' }}">
                                            {{ showDateTime($coupon->expired_at, 'd M, Y h:i A') }}
                                        </td>
                                        <td>
                                            @if ($coupon->status == Status::ENABLE)
                                                <span class="badge badge--success">@lang('Enabled')</span>
                                            @else
                                                <span class="badge badge--danger">@lang('Disabled')</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <a href="{{ route('admin.coupon.create', $coupon->id) }}" class="btn btn-outline--primary btn-sm "><i class="la la-pencil"></i> @lang('Edit')</a>
                                                @if (!$coupon->status)
                                                    <button class="btn btn-outline--success confirmationBtn" data-action="{{ route('admin.coupon.status', $coupon->id) }}" data-question="@lang('Are you sure to enable this coupon?')">
                                                        <i class="la la-eye"></i>@lang('Enable')
                                                    </button>
                                                @else
                                                    <button class="btn btn-outline--danger confirmationBtn" data-action="{{ route('admin.coupon.status', $coupon->id) }}" data-question="@lang('Are you sure to disable this coupon?')">
                                                        <i class="la la-eye-slash"></i>@lang('Disable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                @if ($coupons->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($coupons) }}
                    </div>
                @endif
            </div>
        </div>
    </div>


    <div class="modal fade" id="couponModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST" action="">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="col-12">
                                <label>@lang('Coupon Name') </label>
                                <input type="text" class="form-control" name="coupon_name" value="{{ old('coupon_name') }}" />
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="input-group">
                                <label class="form-label">@lang('Coupon Code')</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="coupon_code" value="{{ old('coupon_code') }}" required>
                                    <button type="button" class="input-group-text generateCoupon">@lang('Generate')</button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label>@lang('Discount Type')</label>
                            <select class="form-control" name="discount_type" required>
                                <option value="" selected disabled>@lang('Select One')</option>
                                <option value="{{ Status::DISCOUNT_FIXED }}">@lang('Flat')</option>
                                <option value="{{ Status::DISCOUNT_PERCENT }}">@lang('Percentage')</option>
                            </select>
                        </div>

                        <div class="form-group row">
                            <label>@lang('Amount')</label>
                            <div class="input-group">
                                <input type="number" step="any" class="form-control" name="amount" value="{{ old('amount') }}" required>
                                <span class="input-group-text" id="couponAmountType"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="expired_at">@lang('Expired At')</label>
                            <small class="text-muted" title="@lang('The coupon will expire on the selected date. Leave it empty if you do not want to set an expiry date.')"><i class="la la-info-circle"></i></small>
                            <input type="text" name="expired_at" class="form-control datepicker" data-language='en' value="{{ old('expired_at') }}" autocomplete="off">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <div class="d-flex gap-3">
        <x-search-form placeholder="Name, Code" />
        <a href="{{ route('admin.coupon.create') }}" type="button" class="btn btn-sm btn-outline--primary" > <i class="las la-plus"></i> @lang('Add New')</a>
    </div>
@endpush


