<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class UserNotification extends Model
{
    public function readBadge(): Attribute
    {
        return new Attribute(function () {
            $html = '';

            if ($this->is_read == 0) {
                $html = '<span class="badge badge--primary">' . trans('Unread') . '</span>';
            } else {
                $html = '<span class="badge badge--success">' . trans('Read') . '</span>';
            }
            return $html;
        });
    }
}
