<?php

namespace App\Http\Middleware;

use Auth;
use Closure;

class CheckPlanStatus {
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next) {
        if (Auth::check()) {
            $user = auth()->user();
            if ($user->expired_at > now()) {
                return $next($request);
            } else {
                return to_route('user.member.index');
            }
        }
        abort(403);
    }
}
