<?php

namespace App\Http\Controllers\Admin;

use App\Models\Coupon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;

class CouponController extends Controller
{
    public function index()
    {
        $pageTitle = 'Coupons';
        $coupons = Coupon::latest()->searchable(['name', 'code'])->paginate(getPaginate());
        return view('admin.coupons.index', compact('pageTitle', 'coupons'));
    }

    public function createForm($id = 0) {
        if($id){
            $coupon = Coupon::findOrFail($id);
            $pageTitle = 'Edit Coupon';
            return view('admin.coupons.create', compact('pageTitle', 'coupon'));
        }
        $pageTitle = 'Add Coupon';
        return view('admin.coupons.create', compact('pageTitle'));
    }

    public function store(Request $request, $id = 0)
    {
        $request->validate([
            'name'              => 'required|string|max:255|unique:coupons,name,' . $id,
            'code'              => 'required|string|max:255|unique:coupons,code,' . $id,
            'discount_type'     => 'required|numeric|in:1,2',
            'amount'            => 'required|numeric',
            'minimum_spend'     => 'required|numeric',
            'started_at'      => 'required|date',
            'expired_at'        => 'required|date|after_or_equal:started_date',
        ]);

        if($id){
            $coupon = Coupon::findOrFail($id);
            $message = "Coupon Updated Successfully";

        }else{
            $coupon = new Coupon();
            $message = "Coupon Created Successfully";
        }
        $coupon->name                       = $request->name;
        $coupon->code                       = $request->code;
        $coupon->discount_type              = $request->discount_type;
        $coupon->amount                     = $request->amount;
        $coupon->minimum_spend              = $request->minimum_spend;
        $coupon->usage_limit_per_coupon     = $request->usage_limit_per_coupon;
        $coupon->usage_limit_per_customer   = $request->usage_limit_per_customer;
        $coupon->started_at                 = Carbon::parse($request->started_at)->toDateTimeString();
        $coupon->expired_at                 = Carbon::parse($request->expired_at)->toDateTimeString();
        $coupon->save();

        $notify[] = ['success', $message];
        return back()->withNotify($notify);
    }

    public function changeStatus($id){
        return Coupon::changeStatus($id);
    }
}
